/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain;

import com.atlassian.jira.rest.client.api.AddressableEntity;
import com.atlassian.jira.rest.client.api.domain.BasicUser;
import com.atlassian.jira.rest.client.api.domain.Visibility;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.net.URI;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class Comment
implements AddressableEntity {
    private final URI self;
    @Nullable
    private final Long id;
    @Nullable
    private final BasicUser author;
    @Nullable
    private final BasicUser updateAuthor;
    private final DateTime creationDate;
    private final DateTime updateDate;
    private final String body;
    @Nullable
    private final Visibility visibility;

    public Comment(URI self, String body, @Nullable BasicUser author, @Nullable BasicUser updateAuthor, DateTime creationDate, DateTime updateDate, Visibility visibility, @Nullable Long id) {
        this.author = author;
        this.updateAuthor = updateAuthor;
        this.creationDate = creationDate;
        this.updateDate = updateDate;
        this.body = body;
        this.self = self;
        this.visibility = visibility;
        this.id = id;
    }

    public static Comment valueOf(String body) {
        return new Comment(null, body, null, null, null, null, null, null);
    }

    public static Comment createWithRoleLevel(String body, String roleLevel) {
        return new Comment(null, body, null, null, null, null, Visibility.role(roleLevel), null);
    }

    public static Comment createWithGroupLevel(String body, String groupLevel) {
        return new Comment(null, body, null, null, null, null, Visibility.group(groupLevel), null);
    }

    public boolean wasUpdated() {
        return this.updateDate.isAfter((ReadableInstant)this.creationDate);
    }

    public String getBody() {
        return this.body;
    }

    @Nullable
    public Long getId() {
        return this.id;
    }

    @Override
    public URI getSelf() {
        return this.self;
    }

    @Nullable
    public BasicUser getAuthor() {
        return this.author;
    }

    @Nullable
    public BasicUser getUpdateAuthor() {
        return this.updateAuthor;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public DateTime getUpdateDate() {
        return this.updateDate;
    }

    @Nullable
    public Visibility getVisibility() {
        return this.visibility;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("self", this.self).add("id", this.id).add("body", this.body).add("author", this.author).add("updateAuthor", this.updateAuthor).add("creationDate", this.creationDate).add("visibility", this.visibility).add("updateDate", this.updateDate).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Comment) {
            Comment that = (Comment)obj;
            return Objects.equal(this.self, that.self) && Objects.equal(this.id, that.id) && Objects.equal(this.body, that.body) && Objects.equal(this.author, that.author) && Objects.equal(this.updateAuthor, that.updateAuthor) && Objects.equal(this.creationDate, that.creationDate) && Objects.equal(this.updateDate, that.updateDate) && Objects.equal(this.visibility, that.visibility) && Objects.equal(this.body, that.body);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.self, this.id, this.body, this.author, this.updateAuthor, this.creationDate, this.updateDate, this.visibility);
    }
}

