/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.provision.service.MonitorHolder;
import org.opennms.netmgt.provision.service.TimeTrackingMonitor;
import org.opennms.netmgt.provision.service.operations.ProvisionMonitor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="provisiond")
@Transactional
@Tag(name="Provisiond", description="Provisiond API")
public class ProvisiondStatusRestService {
    private MonitorHolder getMonitorHolder() {
        return (MonitorHolder)BeanUtils.getBean((String)"provisiondContext", (String)"monitorHolder", MonitorHolder.class);
    }

    @GET
    @Path(value="status")
    @Produces(value={"application/json"})
    @Operation(summary="Get all jobs status", description="Get all recent provisiond jobs status.", operationId="ProvisiondStatusRestServiceGETStatusOfJobs")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="all jobs current monitor object.", content={@Content(schema=@Schema(type="Map<String, TimeTrackingMonitor>"))})})
    public Response getAllJobStatus() {
        MonitorHolder monitorHolder = this.getMonitorHolder();
        return Response.ok((Object)monitorHolder.getMonitors()).build();
    }

    @GET
    @Path(value="status/{jobId}")
    @Produces(value={"application/json"})
    @Operation(summary="Get single job status", description="Get single provisiond job status by jobId", operationId="ProvisiondStatusRestServiceGETStatusOfJobByJobId")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The current job status.", content={@Content(schema=@Schema(implementation=TimeTrackingMonitor.class))}), @ApiResponse(responseCode="404", description="jobId not exist.", content={@Content})})
    public Response getJobStatus(@PathParam(value="jobId") String jobId) {
        MonitorHolder monitorHolder = this.getMonitorHolder();
        ProvisionMonitor monitor = (ProvisionMonitor)monitorHolder.getMonitors().get(jobId);
        if (monitor != null) {
            return Response.ok((Object)monitor).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

