/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support;

import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.builder.ToStringBuilder;

@XmlRootElement(name="property")
public class SearchProperty
implements Comparable<SearchProperty> {
    public static final boolean DEFAULT_ORDER_BY = true;
    public static final boolean DEFAULT_IPLIKE = false;
    private static final Comparator<SearchProperty> COMPARATOR = Comparator.comparing(t -> t.entityClass.getName()).thenComparing(SearchProperty::getId);
    public static final Map<String, String> TRUE_OR_FALSE_VALUES = ImmutableMap.builder().put((Object)"1", (Object)"TRUE").put((Object)"0", (Object)"FALSE").build();
    @XmlTransient
    public Class<?> entityClass;
    @XmlTransient
    String idPrefix;
    @XmlTransient
    public String id;
    @XmlTransient
    String namePrefix;
    @XmlTransient
    public String name;
    @XmlAttribute
    public SearchPropertyType type;
    @XmlAttribute
    public boolean orderBy;
    @XmlAttribute
    public boolean iplike;
    @XmlElementWrapper(name="values")
    public Map<String, String> values;

    public SearchProperty() {
    }

    public SearchProperty(Class<?> entityClass, String id, String name, SearchPropertyType type) {
        this(entityClass, id, name, type, null);
    }

    public SearchProperty(Class<?> entityClass, String id, String name, SearchPropertyType type, Map<String, String> values) {
        this(entityClass, null, id, null, name, type, true, false, values);
    }

    public SearchProperty(Class<?> entityClass, String idPrefix, String id, String namePrefix, String name, SearchPropertyType type, boolean orderBy, boolean iplike, Map<String, String> values) {
        this.entityClass = entityClass;
        this.idPrefix = idPrefix;
        this.id = id;
        this.namePrefix = namePrefix;
        this.name = name;
        this.type = type;
        this.orderBy = orderBy;
        this.iplike = iplike;
        this.values = values;
    }

    @XmlAttribute
    public String getId() {
        return this.idPrefix == null ? this.id : this.idPrefix + "." + this.id;
    }

    @XmlAttribute
    public String getName() {
        return this.namePrefix == null ? this.name : this.namePrefix + ": " + this.name;
    }

    @Override
    public int compareTo(SearchProperty o) {
        return COMPARATOR.compare(this, o);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("idPrefix", (Object)this.idPrefix).append("id", (Object)this.id).append("namePrefix", (Object)this.namePrefix).append("name", (Object)this.name).append("type", (Object)this.type.toString()).append("iplike", this.iplike).append("orderBy", this.orderBy).build();
    }

    public static enum SearchPropertyType {
        BOOLEAN,
        FLOAT,
        INTEGER,
        IP_ADDRESS,
        LONG,
        STRING,
        TIMESTAMP;

    }
}

