/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.processing.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.flows.Flow;
import org.opennms.integration.api.v1.flows.FlowException;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.flows.processing.enrichment.EnrichedFlow;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceMarkerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(InterfaceMarkerImpl.class);
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("initialize-marker-cache").build();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(this.threadFactory);
    private final SessionUtils sessionUtils;
    private final NodeDao nodeDao;
    private final SnmpInterfaceDao snmpInterfaceDao;
    private final CountDownLatch markerCacheSyncDone = new CountDownLatch(1);
    private final Map<Flow.Direction, Cache<Integer, Set<Integer>>> markerCache = Maps.newEnumMap(Flow.Direction.class);

    public InterfaceMarkerImpl(SessionUtils sessionUtils, NodeDao nodeDao, SnmpInterfaceDao snmpInterfaceDao) {
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.snmpInterfaceDao = Objects.requireNonNull(snmpInterfaceDao);
        this.markerCache.put(Flow.Direction.INGRESS, (Cache<Integer, Set<Integer>>)CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build());
        this.markerCache.put(Flow.Direction.EGRESS, (Cache<Integer, Set<Integer>>)CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build());
        this.executorService.execute(this::initializeMarkerCache);
    }

    private void initializeMarkerCache() {
        this.sessionUtils.withTransaction(() -> {
            for (OnmsNode node : this.nodeDao.findAllHavingIngressFlows()) {
                this.markerCache.get(Flow.Direction.INGRESS).put((Object)node.getId(), (Object)this.snmpInterfaceDao.findAllHavingIngressFlows(node.getId()).stream().map(OnmsSnmpInterface::getIfIndex).collect(Collectors.toCollection(Sets::newConcurrentHashSet)));
            }
            for (OnmsNode node : this.nodeDao.findAllHavingEgressFlows()) {
                this.markerCache.get(Flow.Direction.EGRESS).put((Object)node.getId(), (Object)this.snmpInterfaceDao.findAllHavingEgressFlows(node.getId()).stream().map(OnmsSnmpInterface::getIfIndex).collect(Collectors.toCollection(Sets::newConcurrentHashSet)));
            }
            this.markerCacheSyncDone.countDown();
            return null;
        });
    }

    public void mark(List<EnrichedFlow> flows) {
        try {
            this.markerCacheSyncDone.await();
        }
        catch (InterruptedException e) {
            LOG.warn("Marker Cache sync wait was interrupted", (Throwable)e);
        }
        EnumMap nodesToUpdate = Maps.newEnumMap(Flow.Direction.class);
        EnumMap interfacesToUpdate = Maps.newEnumMap(Flow.Direction.class);
        nodesToUpdate.put(Flow.Direction.INGRESS, Lists.newArrayListWithExpectedSize((int)flows.size()));
        nodesToUpdate.put(Flow.Direction.EGRESS, Lists.newArrayListWithExpectedSize((int)flows.size()));
        interfacesToUpdate.put(Flow.Direction.INGRESS, Maps.newHashMap());
        interfacesToUpdate.put(Flow.Direction.EGRESS, Maps.newHashMap());
        for (EnrichedFlow flow : flows) {
            if (flow.getExporterNodeInfo() == null) continue;
            Integer nodeId = flow.getExporterNodeInfo().getNodeId();
            if (flow.getInputSnmp() != null && flow.getInputSnmp() != 0 && (flow.getDirection() == Flow.Direction.INGRESS || flow.getDirection() == Flow.Direction.UNKNOWN)) {
                Set ingressMarkerCache = (Set)this.markerCache.get(Flow.Direction.INGRESS).getIfPresent((Object)nodeId);
                if (ingressMarkerCache == null) {
                    ingressMarkerCache = Sets.newConcurrentHashSet();
                    this.markerCache.get(Flow.Direction.INGRESS).put((Object)nodeId, (Object)ingressMarkerCache);
                    ((List)nodesToUpdate.get(Flow.Direction.INGRESS)).add(nodeId);
                }
                if (!ingressMarkerCache.contains(flow.getInputSnmp())) {
                    ingressMarkerCache.add(flow.getInputSnmp());
                    ((Map)interfacesToUpdate.get(Flow.Direction.INGRESS)).computeIfAbsent(nodeId, k -> Lists.newArrayList()).add(flow.getInputSnmp());
                }
            }
            if (flow.getOutputSnmp() == null || flow.getOutputSnmp() == 0 || flow.getDirection() != Flow.Direction.EGRESS && flow.getDirection() != Flow.Direction.UNKNOWN) continue;
            Set egressMarkerCache = (Set)this.markerCache.get(Flow.Direction.EGRESS).getIfPresent((Object)nodeId);
            if (egressMarkerCache == null) {
                egressMarkerCache = Sets.newConcurrentHashSet();
                this.markerCache.get(Flow.Direction.EGRESS).put((Object)nodeId, (Object)egressMarkerCache);
                ((List)nodesToUpdate.get(Flow.Direction.EGRESS)).add(nodeId);
            }
            if (egressMarkerCache.contains(flow.getOutputSnmp())) continue;
            egressMarkerCache.add(flow.getOutputSnmp());
            ((Map)interfacesToUpdate.get(Flow.Direction.EGRESS)).computeIfAbsent(nodeId, k -> Lists.newArrayList()).add(flow.getOutputSnmp());
        }
        if (!(((List)nodesToUpdate.get(Flow.Direction.INGRESS)).isEmpty() && ((Map)interfacesToUpdate.get(Flow.Direction.INGRESS)).isEmpty() && ((List)nodesToUpdate.get(Flow.Direction.EGRESS)).isEmpty() && ((Map)interfacesToUpdate.get(Flow.Direction.EGRESS)).isEmpty())) {
            this.sessionUtils.withTransaction(() -> {
                if (!((List)nodesToUpdate.get(Flow.Direction.INGRESS)).isEmpty() || !((List)nodesToUpdate.get(Flow.Direction.EGRESS)).isEmpty()) {
                    this.nodeDao.markHavingFlows((Collection)nodesToUpdate.get(Flow.Direction.INGRESS), (Collection)nodesToUpdate.get(Flow.Direction.EGRESS));
                }
                for (Map.Entry e : ((Map)interfacesToUpdate.get(Flow.Direction.INGRESS)).entrySet()) {
                    this.snmpInterfaceDao.markHavingIngressFlows((Integer)e.getKey(), (Collection)e.getValue());
                }
                for (Map.Entry e : ((Map)interfacesToUpdate.get(Flow.Direction.EGRESS)).entrySet()) {
                    this.snmpInterfaceDao.markHavingEgressFlows((Integer)e.getKey(), (Collection)e.getValue());
                }
                return null;
            });
        }
    }

    public void stop() throws FlowException {
        this.markerCacheSyncDone.countDown();
        this.executorService.shutdownNow();
    }
}

