/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.com.lowagie.text.pdf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.DocumentFont;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.IntHashtable;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PRIndirectReference;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PRStream;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfDictionary;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfName;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfObject;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfReader;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.fonts.cmaps.CMap;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.fonts.cmaps.CMapParser;

public class CMapAwareDocumentFont
extends DocumentFont {
    private PdfDictionary fontDic;
    private int spaceWidth;
    private CMap toUnicodeCmap;
    private char[] cidbyte2uni;

    public CMapAwareDocumentFont(PRIndirectReference pRIndirectReference) {
        super(pRIndirectReference);
        this.fontDic = (PdfDictionary)PdfReader.getPdfObjectRelease(pRIndirectReference);
        this.processToUnicode();
        if (this.toUnicodeCmap == null) {
            this.processUni2Byte();
        }
        this.spaceWidth = super.getWidth(32);
        if (this.spaceWidth == 0) {
            this.spaceWidth = this.computeAverageWidth();
        }
    }

    private void processToUnicode() {
        PdfObject pdfObject = this.fontDic.get(PdfName.TOUNICODE);
        if (pdfObject != null) {
            try {
                byte[] byArray = PdfReader.getStreamBytes((PRStream)PdfReader.getPdfObjectRelease(pdfObject));
                CMapParser cMapParser = new CMapParser();
                this.toUnicodeCmap = cMapParser.parse(new ByteArrayInputStream(byArray));
            }
            catch (IOException iOException) {
                throw new Error("Unable to process ToUnicode map - " + iOException.getMessage(), iOException);
            }
        }
    }

    private void processUni2Byte() {
        IntHashtable intHashtable = this.getUni2Byte();
        int[] nArray = intHashtable.toOrderedKeys();
        this.cidbyte2uni = new char[256];
        for (int i = 0; i < nArray.length; ++i) {
            int n = intHashtable.get(nArray[i]);
            if (this.cidbyte2uni[n] != '\u0000') continue;
            this.cidbyte2uni[n] = (char)nArray[i];
        }
    }

    private int computeAverageWidth() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.widths.length; ++i) {
            if (this.widths[i] == 0) continue;
            n2 += this.widths[i];
            ++n;
        }
        return n != 0 ? n2 / n : 0;
    }

    public int getWidth(int n) {
        if (n == 32) {
            return this.spaceWidth;
        }
        return super.getWidth(n);
    }

    private String decodeSingleCID(byte[] byArray, int n, int n2) {
        if (this.toUnicodeCmap != null) {
            if (n + n2 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException("Invalid index: " + n + n2);
            }
            return this.toUnicodeCmap.lookup(byArray, n, n2);
        }
        if (n2 == 1) {
            return new String(this.cidbyte2uni, 0xFF & byArray[n], 1);
        }
        throw new Error("Multi-byte glyphs not implemented yet");
    }

    public String decode(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n + n2; ++i) {
            String string = this.decodeSingleCID(byArray, i, 1);
            if (string == null) {
                string = this.decodeSingleCID(byArray, i, 2);
                ++i;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String encode(byte[] byArray, int n, int n2) {
        return this.decode(byArray, n, n2);
    }
}

