/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data;

import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.data.DataSourceProvider;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;

public class DataSourceCollection<D extends JRDataSource, P extends DataSourceProvider<D>>
implements JRDataSource {
    public static final String EXCEPTION_MESSAGE_KEY_METHOD_CALL_ERROR = "data.source.collection.method.call.error";
    protected final boolean empty;
    protected final ListIterator<? extends P> providerIterator;
    protected D currentDataSource;

    public DataSourceCollection(List<? extends P> dataSourceProviders) throws JRException {
        this.empty = dataSourceProviders.isEmpty();
        this.providerIterator = dataSourceProviders.listIterator();
        this.start();
    }

    protected final void start() throws JRException {
        if (this.providerIterator.hasNext()) {
            DataSourceProvider provider = (DataSourceProvider)this.providerIterator.next();
            this.currentDataSource = provider.getDataSource();
        }
    }

    public D currentDataSource() {
        return this.currentDataSource;
    }

    @Override
    public boolean next() throws JRException {
        if (this.empty) {
            return false;
        }
        if (this.currentDataSource != null && this.currentDataSource.next()) {
            return true;
        }
        while (this.providerIterator.hasNext()) {
            DataSourceProvider provider = (DataSourceProvider)this.providerIterator.next();
            this.currentDataSource = provider.getDataSource();
            if (this.currentDataSource == null || !this.currentDataSource.next()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getFieldValue(JRField field) throws JRException {
        if (this.currentDataSource == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_METHOD_CALL_ERROR, (Object[])null);
        }
        return this.currentDataSource.getFieldValue(field);
    }
}

