/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
package org.opennms.netmgt.newts;

import java.util.List;

import org.opennms.newts.api.Sample;

/**
 * Wrapper class for a {@list java.util.List} of {@link org.opennms.newts.api.Sample} objects.
 *
 * Instances of this class are preallocated by the {@link com.lmax.disruptor.dsl.Disruptor}.
 *
 * @author jwhite
 */
public class SampleBatchEvent {
    private List<Sample> m_samples;
    private boolean m_indexOnly;

    public void setSamples(List<Sample> samples) {
        m_samples = samples;
    }

    public List<Sample> getSamples() {
        return m_samples;
    }

    public void setIndexOnly(boolean indexOnly) {
        m_indexOnly = indexOnly;
    }

    public boolean isIndexOnly() {
        return m_indexOnly;
    }
}
