/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "smn" locale.
 */
public class LocalizedNamesImpl_smn extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AL",
        "DZ",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AE",
        "AR",
        "AM",
        "AW",
        "AC",
        "AU",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BQ",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "CV",
        "KY",
        "CD",
        "EA",
        "CG",
        "CL",
        "CP",
        "SJ",
        "CK",
        "CR",
        "CI",
        "CW",
        "DG",
        "DJ",
        "DM",
        "DO",
        "EC",
        "EE",
        "EG",
        "EH",
        "SV",
        "ER",
        "ES",
        "ET",
        "EU",
        "EZ",
        "FK",
        "FO",
        "FJ",
        "PH",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GD",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HK",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JP",
        "JM",
        "YE",
        "JE",
        "JO",
        "CX",
        "KH",
        "CM",
        "CA",
        "IC",
        "KZ",
        "KE",
        "CN",
        "KG",
        "KI",
        "CO",
        "KM",
        "CC",
        "CF",
        "XK",
        "GR",
        "HR",
        "CU",
        "KW",
        "CY",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "ZA",
        "GS",
        "KR",
        "SS",
        "MO",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "IM",
        "MA",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MK",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NF",
        "AT",
        "OM",
        "GB",
        "US",
        "VI",
        "UM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "GQ",
        "PE",
        "PN",
        "PT",
        "PS",
        "PR",
        "PL",
        "QA",
        "QO",
        "FR",
        "GF",
        "TF",
        "PF",
        "RE",
        "RO",
        "RW",
        "RU",
        "SE",
        "SH",
        "DE",
        "SB",
        "ZM",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SX",
        "SK",
        "SI",
        "SO",
        "LK",
        "BL",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "SD",
        "FI",
        "SR",
        "CH",
        "SZ",
        "SY",
        "NO",
        "TJ",
        "TW",
        "TZ",
        "DK",
        "KP",
        "MP",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TD",
        "CZ",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "UG",
        "UA",
        "UN",
        "UY",
        "UZ",
        "NC",
        "NZ",
        "HU",
        "VU",
        "VA",
        "VE",
        "BY",
        "VN",
        "NL",
        "AX",
        "WF",
        "XA",
        "XB",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AC", "Ascension-suálui");
    namesMap.put("AE", "Arabiemirkodeh");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua já Barbuda");
    namesMap.put("AQ", "Antarktis");
    namesMap.put("AS", "Amerika Samoa");
    namesMap.put("AT", "Nuorttâriijkâ");
    namesMap.put("AX", "Vuáskueennâm");
    namesMap.put("AZ", "Azerbaidžan");
    namesMap.put("BA", "Bosnia já Herzegovina");
    namesMap.put("BE", "Belgia");
    namesMap.put("BR", "Brasilia");
    namesMap.put("BS", "Bahama");
    namesMap.put("BV", "Bouvetsuálui");
    namesMap.put("BY", "Vielgis-Ruoššâ");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kookossuolluuh (Keelingsuolluuh)");
    namesMap.put("CF", "Koskâ-Afrika täsiväldi");
    namesMap.put("CH", "Sveitsi");
    namesMap.put("CK", "Cooksuolluuh");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Kiina");
    namesMap.put("CO", "Kolumbia");
    namesMap.put("CP", "Clippertonsuálui");
    namesMap.put("CU", "Kuuba");
    namesMap.put("CX", "Juovlâsuálui");
    namesMap.put("CY", "Kypros");
    namesMap.put("CZ", "Tšekki");
    namesMap.put("DE", "Saksa");
    namesMap.put("DK", "Tanska");
    namesMap.put("DO", "Dominikaanisâš täsiväldi");
    namesMap.put("EA", "Ceuta já Melilla");
    namesMap.put("EE", "Eestieennâm");
    namesMap.put("EG", "Egypti");
    namesMap.put("ES", "Espanja");
    namesMap.put("ET", "Etiopia");
    namesMap.put("FI", "Suomâ");
    namesMap.put("FJ", "Fidži");
    namesMap.put("FK", "Falklandsuolluuh");
    namesMap.put("FM", "Mikronesia littoväldi");
    namesMap.put("FO", "Färsuolluuh");
    namesMap.put("FR", "Ranska");
    namesMap.put("GB", "Ovtâstum Kunâgâskodde");
    namesMap.put("GF", "Ranska Guyana");
    namesMap.put("GL", "Grönland");
    namesMap.put("GQ", "Peeivitäsideijee Guinea");
    namesMap.put("GR", "Kreikka");
    namesMap.put("GS", "Maadâ-Georgia já Máddááh Sandwichsuolluuh");
    namesMap.put("HK", "Hongkong – Kiina e.h.k.");
    namesMap.put("HM", "Heard já McDonaldsuolluuh");
    namesMap.put("HR", "Kroatia");
    namesMap.put("HU", "Uŋgar");
    namesMap.put("IC", "Kanariasuolluuh");
    namesMap.put("IE", "Irland");
    namesMap.put("IM", "Mansuálui");
    namesMap.put("IO", "Brittilâš India väldimeerâ kuávlu");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JP", "Jaapaan");
    namesMap.put("KE", "Kenia");
    namesMap.put("KG", "Kirgisia");
    namesMap.put("KH", "Kambodža");
    namesMap.put("KM", "Komoreh");
    namesMap.put("KN", "St. Kitts já Nevis");
    namesMap.put("KP", "Tave-Korea");
    namesMap.put("KR", "Maadâ-Korea");
    namesMap.put("KY", "Caymansuolluuh");
    namesMap.put("KZ", "Kazakstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LT", "Liettua");
    namesMap.put("LU", "Luxemburg");
    namesMap.put("MA", "Marokko");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshallsuolluuh");
    namesMap.put("MO", "Macao - – Kiina e.h.k.");
    namesMap.put("MP", "Tave-Marianeh");
    namesMap.put("MV", "Malediveh");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NC", "Uđđâ-Kaledonia");
    namesMap.put("NF", "Norfolksuálui");
    namesMap.put("NL", "Vuáládâhenâmeh");
    namesMap.put("NO", "Taažâ");
    namesMap.put("NZ", "Uđđâ-Seeland");
    namesMap.put("PF", "Ranska Polynesia");
    namesMap.put("PG", "Papua-Uđđâ-Guinea");
    namesMap.put("PH", "Filipineh");
    namesMap.put("PL", "Puola");
    namesMap.put("PM", "St. Pierre já Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("RU", "Ruoššâ");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SB", "Salomosuolluuh");
    namesMap.put("SC", "Seychelleh");
    namesMap.put("SE", "Ruotâ");
    namesMap.put("SH", "Saint Helena");
    namesMap.put("SJ", "Čokkeväärih já Jan Mayen");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Maadâ-Sudan");
    namesMap.put("ST", "São Tomé já Príncipe");
    namesMap.put("SZ", "Swazieennâm");
    namesMap.put("TC", "Turks- já Caicossuolluuh");
    namesMap.put("TD", "Tšad");
    namesMap.put("TF", "Ranska máddááh kuávluh");
    namesMap.put("TH", "Thaieennâm");
    namesMap.put("TJ", "Tadžikistan");
    namesMap.put("TR", "Turkki");
    namesMap.put("TT", "Trinidad já Tobago");
    namesMap.put("TZ", "Tansania");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "Ovtâstum Staatâi sierânâssuolluuh");
    namesMap.put("US", "Ovtâstum Staatah");
    namesMap.put("VA", "Vatikan");
    namesMap.put("VC", "St. Vincent já Grenadines");
    namesMap.put("VG", "Brittiliih Nieidâsuolluuh");
    namesMap.put("VI", "Ovtâstum Staatâi Nieidâsuolluuh");
    namesMap.put("WF", "Wallis já Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Maadâ-Afrikka");
    namesMap.put("ZM", "Sambia");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AC": "Ascension-suálui",
        "AE": "Arabiemirkodeh",
        "AF": "Afganistan",
        "AG": "Antigua já Barbuda",
        "AQ": "Antarktis",
        "AS": "Amerika Samoa",
        "AT": "Nuorttâriijkâ",
        "AX": "Vuáskueennâm",
        "AZ": "Azerbaidžan",
        "BA": "Bosnia já Herzegovina",
        "BE": "Belgia",
        "BR": "Brasilia",
        "BS": "Bahama",
        "BV": "Bouvetsuálui",
        "BY": "Vielgis-Ruoššâ",
        "CA": "Kanada",
        "CC": "Kookossuolluuh (Keelingsuolluuh)",
        "CF": "Koskâ-Afrika täsiväldi",
        "CH": "Sveitsi",
        "CK": "Cooksuolluuh",
        "CM": "Kamerun",
        "CN": "Kiina",
        "CO": "Kolumbia",
        "CP": "Clippertonsuálui",
        "CU": "Kuuba",
        "CX": "Juovlâsuálui",
        "CY": "Kypros",
        "CZ": "Tšekki",
        "DE": "Saksa",
        "DK": "Tanska",
        "DO": "Dominikaanisâš täsiväldi",
        "EA": "Ceuta já Melilla",
        "EE": "Eestieennâm",
        "EG": "Egypti",
        "ES": "Espanja",
        "ET": "Etiopia",
        "FI": "Suomâ",
        "FJ": "Fidži",
        "FK": "Falklandsuolluuh",
        "FM": "Mikronesia littoväldi",
        "FO": "Färsuolluuh",
        "FR": "Ranska",
        "GB": "Ovtâstum Kunâgâskodde",
        "GF": "Ranska Guyana",
        "GL": "Grönland",
        "GQ": "Peeivitäsideijee Guinea",
        "GR": "Kreikka",
        "GS": "Maadâ-Georgia já Máddááh Sandwichsuolluuh",
        "HK": "Hongkong – Kiina e.h.k.",
        "HM": "Heard já McDonaldsuolluuh",
        "HR": "Kroatia",
        "HU": "Uŋgar",
        "IC": "Kanariasuolluuh",
        "IE": "Irland",
        "IM": "Mansuálui",
        "IO": "Brittilâš India väldimeerâ kuávlu",
        "IQ": "Irak",
        "IS": "Island",
        "IT": "Italia",
        "JM": "Jamaika",
        "JP": "Jaapaan",
        "KE": "Kenia",
        "KG": "Kirgisia",
        "KH": "Kambodža",
        "KM": "Komoreh",
        "KN": "St. Kitts já Nevis",
        "KP": "Tave-Korea",
        "KR": "Maadâ-Korea",
        "KY": "Caymansuolluuh",
        "KZ": "Kazakstan",
        "LB": "Libanon",
        "LT": "Liettua",
        "LU": "Luxemburg",
        "MA": "Marokko",
        "MG": "Madagaskar",
        "MH": "Marshallsuolluuh",
        "MO": "Macao - – Kiina e.h.k.",
        "MP": "Tave-Marianeh",
        "MV": "Malediveh",
        "MX": "Meksiko",
        "MZ": "Mosambik",
        "NC": "Uđđâ-Kaledonia",
        "NF": "Norfolksuálui",
        "NL": "Vuáládâhenâmeh",
        "NO": "Taažâ",
        "NZ": "Uđđâ-Seeland",
        "PF": "Ranska Polynesia",
        "PG": "Papua-Uđđâ-Guinea",
        "PH": "Filipineh",
        "PL": "Puola",
        "PM": "St. Pierre já Miquelon",
        "PN": "Pitcairn",
        "RU": "Ruoššâ",
        "RW": "Ruanda",
        "SB": "Salomosuolluuh",
        "SC": "Seychelleh",
        "SE": "Ruotâ",
        "SH": "Saint Helena",
        "SJ": "Čokkeväärih já Jan Mayen",
        "SR": "Surinam",
        "SS": "Maadâ-Sudan",
        "ST": "São Tomé já Príncipe",
        "SZ": "Swazieennâm",
        "TC": "Turks- já Caicossuolluuh",
        "TD": "Tšad",
        "TF": "Ranska máddááh kuávluh",
        "TH": "Thaieennâm",
        "TJ": "Tadžikistan",
        "TR": "Turkki",
        "TT": "Trinidad já Tobago",
        "TZ": "Tansania",
        "UA": "Ukraina",
        "UM": "Ovtâstum Staatâi sierânâssuolluuh",
        "US": "Ovtâstum Staatah",
        "VA": "Vatikan",
        "VC": "St. Vincent já Grenadines",
        "VG": "Brittiliih Nieidâsuolluuh",
        "VI": "Ovtâstum Staatâi Nieidâsuolluuh",
        "WF": "Wallis já Futuna",
        "YE": "Jemen",
        "ZA": "Maadâ-Afrikka",
        "ZM": "Sambia"
    };
  }-*/;
}
