/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "bm" locale.
 */
public class LocalizedNamesImpl_bm extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "AL",
        "DE",
        "DZ",
        "US",
        "VI",
        "AD",
        "VG",
        "IO",
        "GB",
        "AI",
        "AO",
        "AG",
        "AQ",
        "SA",
        "AE",
        "AM",
        "AR",
        "AW",
        "AX",
        "HT",
        "AZ",
        "BS",
        "KY",
        "BB",
        "BH",
        "BY",
        "BZ",
        "BJ",
        "BR",
        "BM",
        "BL",
        "BO",
        "BA",
        "BQ",
        "BG",
        "BN",
        "BF",
        "BI",
        "BT",
        "BV",
        "BW",
        "BE",
        "BD",
        "TD",
        "CV",
        "CC",
        "CZ",
        "CY",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "DO",
        "DM",
        "EA",
        "EH",
        "EC",
        "ER",
        "EE",
        "ES",
        "ET",
        "EU",
        "EZ",
        "EG",
        "FR",
        "GF",
        "PF",
        "FJ",
        "PH",
        "FI",
        "FO",
        "GA",
        "GH",
        "GM",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GD",
        "GS",
        "GP",
        "GU",
        "GT",
        "GY",
        "GL",
        "GR",
        "HK",
        "HM",
        "HN",
        "HU",
        "IC",
        "IM",
        "IQ",
        "IR",
        "IE",
        "RU",
        "IS",
        "IL",
        "IT",
        "JE",
        "DJ",
        "NC",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KE",
        "KI",
        "KG",
        "CI",
        "CO",
        "KM",
        "CG",
        "CD",
        "KW",
        "KN",
        "HR",
        "CU",
        "CK",
        "TL",
        "CR",
        "KP",
        "MP",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LU",
        "LI",
        "LT",
        "LC",
        "MK",
        "MG",
        "MW",
        "MV",
        "ML",
        "MT",
        "FK",
        "MY",
        "SM",
        "MH",
        "MQ",
        "MA",
        "YT",
        "ME",
        "MX",
        "MF",
        "FM",
        "MO",
        "MD",
        "MC",
        "MU",
        "MZ",
        "MN",
        "MS",
        "MM",
        "MR",
        "NA",
        "NR",
        "NP",
        "NI",
        "NG",
        "NE",
        "NU",
        "NO",
        "NF",
        "OM",
        "AU",
        "AT",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "NL",
        "PN",
        "PM",
        "PL",
        "PT",
        "PR",
        "QO",
        "RE",
        "RS",
        "RO",
        "RW",
        "SV",
        "SB",
        "WS",
        "AS",
        "CF",
        "ST",
        "SN",
        "SC",
        "CL",
        "CN",
        "SY",
        "LK",
        "SL",
        "SJ",
        "SI",
        "SK",
        "SO",
        "SS",
        "SD",
        "SR",
        "CH",
        "SE",
        "SZ",
        "SX",
        "SG",
        "TA",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "TF",
        "TG",
        "TK",
        "TO",
        "TT",
        "TN",
        "TR",
        "TC",
        "TM",
        "TV",
        "UG",
        "UA",
        "UM",
        "UN",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VC",
        "WF",
        "VN",
        "ZA",
        "KR",
        "XA",
        "XB",
        "XK",
        "YE",
        "JM",
        "ZM",
        "JP",
        "NZ",
        "GE",
        "GI",
        "ZW",
        "JO",
        "SH",
        "ID",
        "IN",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andɔr");
    namesMap.put("AE", "Arabu mara kafoli");
    namesMap.put("AF", "Afiganistaŋ");
    namesMap.put("AG", "Antiga-ni-Barbuda");
    namesMap.put("AI", "Angiya");
    namesMap.put("AL", "Alibani");
    namesMap.put("AM", "Arimeni");
    namesMap.put("AR", "Arizantin");
    namesMap.put("AS", "Samowa amerikani");
    namesMap.put("AT", "Otirisi");
    namesMap.put("AU", "Ositirali");
    namesMap.put("AZ", "Azɛrbayjaŋ");
    namesMap.put("BA", "Bozni-Ɛrizigovini");
    namesMap.put("BB", "Barbadi");
    namesMap.put("BD", "Bɛngiladɛsi");
    namesMap.put("BE", "Bɛliziki");
    namesMap.put("BF", "Burukina Faso");
    namesMap.put("BG", "Buligari");
    namesMap.put("BH", "Bareyini");
    namesMap.put("BJ", "Benɛn");
    namesMap.put("BM", "Bermudi");
    namesMap.put("BN", "Burinɛyi");
    namesMap.put("BO", "Bolivi");
    namesMap.put("BR", "Berezili");
    namesMap.put("BS", "Bahamasi");
    namesMap.put("BT", "Butaŋ");
    namesMap.put("BW", "Bɔtisiwana");
    namesMap.put("BY", "Belarusi");
    namesMap.put("BZ", "Belizi");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Kongo ka republiki demɔkratiki");
    namesMap.put("CF", "Santarafiriki");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Suwisi");
    namesMap.put("CI", "Kodiwari");
    namesMap.put("CK", "Kuki Gun");
    namesMap.put("CL", "Sili");
    namesMap.put("CM", "Kameruni");
    namesMap.put("CN", "Siniwajamana");
    namesMap.put("CO", "Kolombi");
    namesMap.put("CR", "Kɔsitarika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Capivɛrdi");
    namesMap.put("CY", "Cipri");
    namesMap.put("CZ", "Ceki republiki");
    namesMap.put("DE", "Alimaɲi");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DK", "Danemarki");
    namesMap.put("DM", "Dɔminiki");
    namesMap.put("DO", "Dɔmimiki republiki");
    namesMap.put("DZ", "Alizeri");
    namesMap.put("EC", "Ekwatɔr");
    namesMap.put("EE", "Esetoni");
    namesMap.put("EG", "Eziputi");
    namesMap.put("ER", "Eritere");
    namesMap.put("ES", "Esipaɲi");
    namesMap.put("ET", "Etiopi");
    namesMap.put("FI", "Finilandi");
    namesMap.put("FK", "Maluwini Gun");
    namesMap.put("FM", "Mikironesi");
    namesMap.put("FR", "Faransi");
    namesMap.put("GA", "Gabɔŋ");
    namesMap.put("GB", "Angilɛtɛri");
    namesMap.put("GD", "Granadi");
    namesMap.put("GE", "Zeyɔrzi");
    namesMap.put("GF", "Faransi ka gwiyani");
    namesMap.put("GH", "Gana");
    namesMap.put("GI", "Zibralitari");
    namesMap.put("GL", "Gɔrɔhenelandi");
    namesMap.put("GM", "Ganbi");
    namesMap.put("GN", "Gine");
    namesMap.put("GP", "Gwadelup");
    namesMap.put("GQ", "Gine ekwatɔri");
    namesMap.put("GR", "Gɛrɛsi");
    namesMap.put("GT", "Gwatemala");
    namesMap.put("GU", "Gwam");
    namesMap.put("GW", "Gine Bisawo");
    namesMap.put("GY", "Gwiyana");
    namesMap.put("HN", "Hɔndirasi");
    namesMap.put("HR", "Kroasi");
    namesMap.put("HT", "Ayiti");
    namesMap.put("HU", "Hɔngri");
    namesMap.put("ID", "Ɛndonezi");
    namesMap.put("IE", "Irilandi");
    namesMap.put("IL", "Isirayeli");
    namesMap.put("IN", "Ɛndujamana");
    namesMap.put("IO", "Angilɛ ka ɛndu dugukolo");
    namesMap.put("IQ", "Iraki");
    namesMap.put("IR", "Iraŋ");
    namesMap.put("IS", "Isilandi");
    namesMap.put("IT", "Itali");
    namesMap.put("JM", "Zamayiki");
    namesMap.put("JO", "Zɔrdani");
    namesMap.put("JP", "Zapɔn");
    namesMap.put("KE", "Keniya");
    namesMap.put("KG", "Kirigizisitaŋ");
    namesMap.put("KH", "Kamboji");
    namesMap.put("KM", "Komɔri");
    namesMap.put("KN", "Kristɔfo-Senu-ni-Ɲevɛs");
    namesMap.put("KP", "Kɛɲɛka Kore");
    namesMap.put("KR", "Worodugu Kore");
    namesMap.put("KW", "Kowɛti");
    namesMap.put("KY", "Bama Gun");
    namesMap.put("KZ", "Kazakistaŋ");
    namesMap.put("LA", "Layosi");
    namesMap.put("LB", "Libaŋ");
    namesMap.put("LC", "Lusi-Senu");
    namesMap.put("LI", "Lisɛnsitayini");
    namesMap.put("LK", "Sirilanka");
    namesMap.put("LR", "Liberiya");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Lituyani");
    namesMap.put("LU", "Likisanburu");
    namesMap.put("LV", "Letoni");
    namesMap.put("LY", "Libi");
    namesMap.put("MA", "Marɔku");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Molidavi");
    namesMap.put("MG", "Madagasikari");
    namesMap.put("MH", "Marisali Gun");
    namesMap.put("MK", "Macedɔni");
    namesMap.put("MM", "Myanimari");
    namesMap.put("MN", "Moŋoli");
    namesMap.put("MP", "Kɛɲɛka Mariyani Gun");
    namesMap.put("MQ", "Maritiniki");
    namesMap.put("MR", "Mɔritani");
    namesMap.put("MS", "Moŋsera");
    namesMap.put("MT", "Malti");
    namesMap.put("MU", "Morisi");
    namesMap.put("MV", "Maldivi");
    namesMap.put("MX", "Meksiki");
    namesMap.put("MY", "Malɛzi");
    namesMap.put("MZ", "Mozanbiki");
    namesMap.put("NA", "Namibi");
    namesMap.put("NC", "Kaledoni Koura");
    namesMap.put("NE", "Nizɛri");
    namesMap.put("NF", "Nɔrofoliki Gun");
    namesMap.put("NG", "Nizeriya");
    namesMap.put("NI", "Nikaragwa");
    namesMap.put("NL", "Peyiba");
    namesMap.put("NO", "Nɔriwɛzi");
    namesMap.put("NP", "Nepali");
    namesMap.put("NR", "Nawuru");
    namesMap.put("NU", "Nyuwe");
    namesMap.put("NZ", "Zelandi Koura");
    namesMap.put("OM", "Omaŋ");
    namesMap.put("PF", "Faransi ka polinezi");
    namesMap.put("PG", "Papuwasi-Gine-Koura");
    namesMap.put("PH", "Filipini");
    namesMap.put("PK", "Pakisitaŋ");
    namesMap.put("PL", "Poloɲi");
    namesMap.put("PM", "Piyɛri-Senu-ni-Mikelɔŋ");
    namesMap.put("PN", "Pitikarini");
    namesMap.put("PR", "Pɔrotoriko");
    namesMap.put("PS", "Palesitini");
    namesMap.put("PT", "Pɔritigali");
    namesMap.put("PW", "Palawu");
    namesMap.put("PY", "Paraguwayi");
    namesMap.put("QA", "Katari");
    namesMap.put("RE", "Reyuɲɔŋ");
    namesMap.put("RO", "Rumani");
    namesMap.put("RU", "Irisi");
    namesMap.put("RW", "Ruwanda");
    namesMap.put("SA", "Arabiya Sawudiya");
    namesMap.put("SB", "Salomo Gun");
    namesMap.put("SC", "Sesɛli");
    namesMap.put("SD", "Sudaŋ");
    namesMap.put("SE", "Suwɛdi");
    namesMap.put("SG", "Sɛngapuri");
    namesMap.put("SH", "Ɛlɛni Senu");
    namesMap.put("SI", "Sloveni");
    namesMap.put("SK", "Slowaki");
    namesMap.put("SL", "Siyera Lewɔni");
    namesMap.put("SM", "Marini-Senu");
    namesMap.put("SN", "Senegali");
    namesMap.put("SO", "Somali");
    namesMap.put("SR", "Surinami");
    namesMap.put("ST", "Sawo Tome-ni-Prinicipe");
    namesMap.put("SV", "Salivadɔr");
    namesMap.put("SY", "Siri");
    namesMap.put("SZ", "Swazilandi");
    namesMap.put("TC", "Turiki Gun ni Kayiki");
    namesMap.put("TD", "Cadi");
    namesMap.put("TH", "Tayilandi");
    namesMap.put("TJ", "Tajikisitani");
    namesMap.put("TK", "Tokelo");
    namesMap.put("TL", "Kɔrɔn Timɔr");
    namesMap.put("TM", "Turikimenisitani");
    namesMap.put("TN", "Tunizi");
    namesMap.put("TR", "Turiki");
    namesMap.put("TT", "Trinite-ni-Tobago");
    namesMap.put("TW", "Tayiwani");
    namesMap.put("TZ", "Tanzani");
    namesMap.put("UA", "Ukɛrɛni");
    namesMap.put("US", "Ameriki");
    namesMap.put("UY", "Urugwayi");
    namesMap.put("UZ", "Uzebekisitani");
    namesMap.put("VA", "Vatikaŋ");
    namesMap.put("VC", "Vinisɛn-Senu-ni-Grenadini");
    namesMap.put("VE", "Venezuwela");
    namesMap.put("VG", "Angilɛ ka Sungurunnin Gun");
    namesMap.put("VI", "Ameriki ka Sungurunnin Gun");
    namesMap.put("VN", "Wiyɛtinamu");
    namesMap.put("VU", "Vanuwatu");
    namesMap.put("WF", "Walisi-ni-Futuna");
    namesMap.put("WS", "Samowa");
    namesMap.put("YE", "Yemɛni");
    namesMap.put("YT", "Mayoti");
    namesMap.put("ZA", "Worodugu Afriki");
    namesMap.put("ZM", "Zanbi");
    namesMap.put("ZW", "Zimbabuwe");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andɔr",
        "AE": "Arabu mara kafoli",
        "AF": "Afiganistaŋ",
        "AG": "Antiga-ni-Barbuda",
        "AI": "Angiya",
        "AL": "Alibani",
        "AM": "Arimeni",
        "AR": "Arizantin",
        "AS": "Samowa amerikani",
        "AT": "Otirisi",
        "AU": "Ositirali",
        "AZ": "Azɛrbayjaŋ",
        "BA": "Bozni-Ɛrizigovini",
        "BB": "Barbadi",
        "BD": "Bɛngiladɛsi",
        "BE": "Bɛliziki",
        "BF": "Burukina Faso",
        "BG": "Buligari",
        "BH": "Bareyini",
        "BJ": "Benɛn",
        "BM": "Bermudi",
        "BN": "Burinɛyi",
        "BO": "Bolivi",
        "BR": "Berezili",
        "BS": "Bahamasi",
        "BT": "Butaŋ",
        "BW": "Bɔtisiwana",
        "BY": "Belarusi",
        "BZ": "Belizi",
        "CA": "Kanada",
        "CD": "Kongo ka republiki demɔkratiki",
        "CF": "Santarafiriki",
        "CG": "Kongo",
        "CH": "Suwisi",
        "CI": "Kodiwari",
        "CK": "Kuki Gun",
        "CL": "Sili",
        "CM": "Kameruni",
        "CN": "Siniwajamana",
        "CO": "Kolombi",
        "CR": "Kɔsitarika",
        "CU": "Kuba",
        "CV": "Capivɛrdi",
        "CY": "Cipri",
        "CZ": "Ceki republiki",
        "DE": "Alimaɲi",
        "DJ": "Jibuti",
        "DK": "Danemarki",
        "DM": "Dɔminiki",
        "DO": "Dɔmimiki republiki",
        "DZ": "Alizeri",
        "EC": "Ekwatɔr",
        "EE": "Esetoni",
        "EG": "Eziputi",
        "ER": "Eritere",
        "ES": "Esipaɲi",
        "ET": "Etiopi",
        "FI": "Finilandi",
        "FK": "Maluwini Gun",
        "FM": "Mikironesi",
        "FR": "Faransi",
        "GA": "Gabɔŋ",
        "GB": "Angilɛtɛri",
        "GD": "Granadi",
        "GE": "Zeyɔrzi",
        "GF": "Faransi ka gwiyani",
        "GH": "Gana",
        "GI": "Zibralitari",
        "GL": "Gɔrɔhenelandi",
        "GM": "Ganbi",
        "GN": "Gine",
        "GP": "Gwadelup",
        "GQ": "Gine ekwatɔri",
        "GR": "Gɛrɛsi",
        "GT": "Gwatemala",
        "GU": "Gwam",
        "GW": "Gine Bisawo",
        "GY": "Gwiyana",
        "HN": "Hɔndirasi",
        "HR": "Kroasi",
        "HT": "Ayiti",
        "HU": "Hɔngri",
        "ID": "Ɛndonezi",
        "IE": "Irilandi",
        "IL": "Isirayeli",
        "IN": "Ɛndujamana",
        "IO": "Angilɛ ka ɛndu dugukolo",
        "IQ": "Iraki",
        "IR": "Iraŋ",
        "IS": "Isilandi",
        "IT": "Itali",
        "JM": "Zamayiki",
        "JO": "Zɔrdani",
        "JP": "Zapɔn",
        "KE": "Keniya",
        "KG": "Kirigizisitaŋ",
        "KH": "Kamboji",
        "KM": "Komɔri",
        "KN": "Kristɔfo-Senu-ni-Ɲevɛs",
        "KP": "Kɛɲɛka Kore",
        "KR": "Worodugu Kore",
        "KW": "Kowɛti",
        "KY": "Bama Gun",
        "KZ": "Kazakistaŋ",
        "LA": "Layosi",
        "LB": "Libaŋ",
        "LC": "Lusi-Senu",
        "LI": "Lisɛnsitayini",
        "LK": "Sirilanka",
        "LR": "Liberiya",
        "LS": "Lesoto",
        "LT": "Lituyani",
        "LU": "Likisanburu",
        "LV": "Letoni",
        "LY": "Libi",
        "MA": "Marɔku",
        "MC": "Monako",
        "MD": "Molidavi",
        "MG": "Madagasikari",
        "MH": "Marisali Gun",
        "MK": "Macedɔni",
        "MM": "Myanimari",
        "MN": "Moŋoli",
        "MP": "Kɛɲɛka Mariyani Gun",
        "MQ": "Maritiniki",
        "MR": "Mɔritani",
        "MS": "Moŋsera",
        "MT": "Malti",
        "MU": "Morisi",
        "MV": "Maldivi",
        "MX": "Meksiki",
        "MY": "Malɛzi",
        "MZ": "Mozanbiki",
        "NA": "Namibi",
        "NC": "Kaledoni Koura",
        "NE": "Nizɛri",
        "NF": "Nɔrofoliki Gun",
        "NG": "Nizeriya",
        "NI": "Nikaragwa",
        "NL": "Peyiba",
        "NO": "Nɔriwɛzi",
        "NP": "Nepali",
        "NR": "Nawuru",
        "NU": "Nyuwe",
        "NZ": "Zelandi Koura",
        "OM": "Omaŋ",
        "PF": "Faransi ka polinezi",
        "PG": "Papuwasi-Gine-Koura",
        "PH": "Filipini",
        "PK": "Pakisitaŋ",
        "PL": "Poloɲi",
        "PM": "Piyɛri-Senu-ni-Mikelɔŋ",
        "PN": "Pitikarini",
        "PR": "Pɔrotoriko",
        "PS": "Palesitini",
        "PT": "Pɔritigali",
        "PW": "Palawu",
        "PY": "Paraguwayi",
        "QA": "Katari",
        "RE": "Reyuɲɔŋ",
        "RO": "Rumani",
        "RU": "Irisi",
        "RW": "Ruwanda",
        "SA": "Arabiya Sawudiya",
        "SB": "Salomo Gun",
        "SC": "Sesɛli",
        "SD": "Sudaŋ",
        "SE": "Suwɛdi",
        "SG": "Sɛngapuri",
        "SH": "Ɛlɛni Senu",
        "SI": "Sloveni",
        "SK": "Slowaki",
        "SL": "Siyera Lewɔni",
        "SM": "Marini-Senu",
        "SN": "Senegali",
        "SO": "Somali",
        "SR": "Surinami",
        "ST": "Sawo Tome-ni-Prinicipe",
        "SV": "Salivadɔr",
        "SY": "Siri",
        "SZ": "Swazilandi",
        "TC": "Turiki Gun ni Kayiki",
        "TD": "Cadi",
        "TH": "Tayilandi",
        "TJ": "Tajikisitani",
        "TK": "Tokelo",
        "TL": "Kɔrɔn Timɔr",
        "TM": "Turikimenisitani",
        "TN": "Tunizi",
        "TR": "Turiki",
        "TT": "Trinite-ni-Tobago",
        "TW": "Tayiwani",
        "TZ": "Tanzani",
        "UA": "Ukɛrɛni",
        "US": "Ameriki",
        "UY": "Urugwayi",
        "UZ": "Uzebekisitani",
        "VA": "Vatikaŋ",
        "VC": "Vinisɛn-Senu-ni-Grenadini",
        "VE": "Venezuwela",
        "VG": "Angilɛ ka Sungurunnin Gun",
        "VI": "Ameriki ka Sungurunnin Gun",
        "VN": "Wiyɛtinamu",
        "VU": "Vanuwatu",
        "WF": "Walisi-ni-Futuna",
        "WS": "Samowa",
        "YE": "Yemɛni",
        "YT": "Mayoti",
        "ZA": "Worodugu Afriki",
        "ZM": "Zanbi",
        "ZW": "Zimbabuwe"
    };
  }-*/;
}
