/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.crypto.tls;

import java.io.IOException;
import org.opennms.shaded.org.bouncycastle.crypto.CryptoException;
import org.opennms.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.opennms.shaded.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.RSAKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.tls.Certificate;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsClientContext;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsDSSSigner;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsECDSASigner;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsRSASigner;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsSigner;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsSignerCredentials;

public class DefaultTlsSignerCredentials
implements TlsSignerCredentials {
    protected TlsClientContext context;
    protected Certificate clientCert;
    protected AsymmetricKeyParameter clientPrivateKey;
    protected TlsSigner clientSigner;

    public DefaultTlsSignerCredentials(TlsClientContext tlsClientContext, Certificate certificate, AsymmetricKeyParameter asymmetricKeyParameter) {
        if (certificate == null) {
            throw new IllegalArgumentException("'clientCertificate' cannot be null");
        }
        if (certificate.certs.length == 0) {
            throw new IllegalArgumentException("'clientCertificate' cannot be empty");
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("'clientPrivateKey' cannot be null");
        }
        if (!asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("'clientPrivateKey' must be private");
        }
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            this.clientSigner = new TlsRSASigner();
        } else if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
            this.clientSigner = new TlsDSSSigner();
        } else if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            this.clientSigner = new TlsECDSASigner();
        } else {
            throw new IllegalArgumentException("'clientPrivateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
        this.context = tlsClientContext;
        this.clientCert = certificate;
        this.clientPrivateKey = asymmetricKeyParameter;
    }

    public Certificate getCertificate() {
        return this.clientCert;
    }

    public byte[] generateCertificateSignature(byte[] byArray) throws IOException {
        try {
            return this.clientSigner.calculateRawSignature(this.context.getSecureRandom(), this.clientPrivateKey, byArray);
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(80);
        }
    }
}

