/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.dao.impl.util;

import com.google.common.io.Resources;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.dynamic.DynamicJAXBContext;
import org.eclipse.persistence.jaxb.dynamic.DynamicJAXBContextFactory;
import org.eclipse.persistence.oxm.MediaType;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.features.config.dao.api.ConfigConverter;
import org.opennms.features.config.dao.impl.util.XmlSchema;
import org.opennms.features.config.dao.impl.util.XsdHelper;
import org.opennms.features.config.dao.impl.util.XsdModelConverter;
import org.opennms.features.config.exception.SchemaConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public class JaxbXmlConverter
implements ConfigConverter {
    private static final Logger LOG = LoggerFactory.getLogger(JaxbXmlConverter.class);
    public static final String VALUE_TAG = "__VALUE__";
    private final DynamicJAXBContext jaxbContext;
    private final XmlSchema xmlSchema;
    private String xsdName;
    private String rootElement;
    private Map<String, String> elementNameToValueNameMap;

    public JaxbXmlConverter(String xsdName, String rootElement, Map<String, String> elementNameToValueNameMap) throws IOException {
        this.xsdName = Objects.requireNonNull(xsdName);
        this.rootElement = Objects.requireNonNull(rootElement);
        this.elementNameToValueNameMap = elementNameToValueNameMap;
        this.xmlSchema = this.readXmlSchema();
        this.jaxbContext = this.getDynamicJAXBContextForService(this.xmlSchema);
    }

    private XmlSchema readXmlSchema() throws IOException {
        String xsdStr = Resources.toString((URL)XsdHelper.getSchemaPath(this.xsdName), (Charset)StandardCharsets.UTF_8);
        XsdModelConverter xsdModelConverter = new XsdModelConverter(xsdStr);
        XmlSchemaCollection schemaCollection = xsdModelConverter.getCollection();
        List namespaces = Arrays.stream(schemaCollection.getXmlSchemas()).map(org.apache.ws.commons.schema.XmlSchema::getTargetNamespace).filter(targetNamespace -> targetNamespace.contains("opennms")).collect(Collectors.toList());
        if (namespaces.size() != 1) {
            LOG.error("XSD must contain one 'opennms' namespace!");
            throw new SchemaConversionException("XSD must contain one 'opennms' namespace!");
        }
        return new XmlSchema(xsdStr, (String)namespaces.get(0), this.rootElement);
    }

    public String getRootElement() {
        return this.rootElement;
    }

    public String xmlToJson(String sourceXml) {
        try {
            XMLFilter filter = JaxbUtils.getXMLFilterForNamespace((String)this.xmlSchema.getNamespace());
            InputSource inputSource = new InputSource(new StringReader(sourceXml));
            SAXSource source = new SAXSource(filter, inputSource);
            JAXBUnmarshaller u = this.jaxbContext.createUnmarshaller();
            DynamicEntity entity = (DynamicEntity)u.unmarshal((Source)source);
            JAXBMarshaller m = this.jaxbContext.createMarshaller();
            m.setProperty("eclipselink.media-type", (Object)MediaType.APPLICATION_JSON);
            m.setProperty("eclipselink.json.include-root", (Object)false);
            m.setProperty("eclipselink.json.value-wrapper", (Object)VALUE_TAG);
            StringWriter writer = new StringWriter();
            m.marshal((Object)entity, (Writer)writer);
            String jsonStr = writer.toString();
            if (jsonStr.indexOf(VALUE_TAG) != -1) {
                JSONObject json = new JSONObject(jsonStr);
                if (!this.elementNameToValueNameMap.isEmpty()) {
                    json = this.replaceXmlValueAttributeName(json);
                }
                json = this.removeEmptyValueTag(json);
                return json.toString();
            }
            return jsonStr;
        }
        catch (JAXBException | SAXException e) {
            throw new SchemaConversionException(sourceXml, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject removeEmptyValueTag(JSONObject json) {
        Objects.requireNonNull(json);
        HashSet keys = new HashSet(json.keySet());
        for (String key : keys) {
            Object value;
            JaxbXmlConverter jaxbXmlConverter = this;
            synchronized (jaxbXmlConverter) {
                if (!json.has(key)) {
                    continue;
                }
                value = json.get(key);
            }
            if (VALUE_TAG.equals(key) && value instanceof String && ((String)value).trim().isEmpty()) {
                json.remove(key);
                continue;
            }
            if (value instanceof JSONObject) {
                this.removeEmptyValueTag((JSONObject)value);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            ((JSONArray)value).forEach(item -> {
                if (item instanceof JSONObject) {
                    this.removeEmptyValueTag((JSONObject)item);
                }
            });
        }
        return json;
    }

    private JSONObject replaceXmlValueAttributeName(JSONObject json) {
        this.elementNameToValueNameMap.forEach((elementName, valueName) -> {
            if (json.has(elementName)) {
                Object value = json.get(elementName);
                if (value instanceof JSONArray) {
                    JSONArray tmpList = (JSONArray)value;
                    tmpList.forEach(item -> {
                        if (item instanceof JSONObject) {
                            this.replaceKey((JSONObject)item, VALUE_TAG, (String)valueName);
                        }
                    });
                } else if (value instanceof JSONObject) {
                    this.replaceKey((JSONObject)value, VALUE_TAG, (String)valueName);
                }
            }
        });
        json.keySet().forEach(key -> {
            Object value = json.get(key);
            if (value instanceof JSONObject) {
                this.replaceXmlValueAttributeName((JSONObject)value);
            } else if (value instanceof JSONArray) {
                ((JSONArray)value).forEach(arrayItem -> {
                    if (arrayItem instanceof JSONObject) {
                        this.replaceXmlValueAttributeName((JSONObject)arrayItem);
                    }
                });
            }
        });
        return json;
    }

    private void replaceKey(JSONObject json, String oldKey, String newKey) {
        Object value = json.remove(oldKey);
        json.put(newKey, value);
    }

    private DynamicJAXBContext getDynamicJAXBContextForService(XmlSchema xmlSchema) {
        DynamicJAXBContext dynamicJAXBContext;
        String xsd = xmlSchema.getXsdContent();
        ByteArrayInputStream is = new ByteArrayInputStream(xsd.getBytes(StandardCharsets.UTF_8));
        try {
            dynamicJAXBContext = DynamicJAXBContextFactory.createContextFromXSD((InputStream)is, null, null, null);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JAXBException e) {
                throw new SchemaConversionException(xsd, e);
            }
        }
        ((InputStream)is).close();
        return dynamicJAXBContext;
    }

    public XmlSchema getXmlSchema() {
        return this.xmlSchema;
    }
}

