/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jni6;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.List;
import java.util.concurrent.Callable;
import org.opennms.core.logging.Logging;
import org.opennms.core.tracker.IDBasedRequestLocator;
import org.opennms.core.tracker.Messenger;
import org.opennms.core.tracker.Request;
import org.opennms.core.tracker.RequestLocator;
import org.opennms.core.tracker.RequestTracker;
import org.opennms.netmgt.icmp.LogPrefixPreservingPingResponseCallback;
import org.opennms.netmgt.icmp.ParallelPingResponseCallback;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.opennms.netmgt.icmp.Pinger;
import org.opennms.netmgt.icmp.SinglePingResponseCallback;
import org.opennms.netmgt.icmp.jni.JniPinger;
import org.opennms.netmgt.icmp.jni6.Jni6IcmpMessenger;
import org.opennms.netmgt.icmp.jni6.Jni6PingRequest;
import org.opennms.netmgt.icmp.jni6.Jni6PingResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jni6Pinger
implements Pinger {
    private static final Logger LOG = LoggerFactory.getLogger(Jni6Pinger.class);
    private final int m_pingerId = new SecureRandom().nextInt(Short.MAX_VALUE);
    private JniPinger m_jniPinger;
    private RequestTracker<Jni6PingRequest, Jni6PingResponse> s_pingTracker;
    private Jni6IcmpMessenger m_jni6messenger;
    private Throwable m_v4Error = null;
    private Throwable m_v6Error = null;

    public synchronized void initialize4() throws Exception {
        if (this.m_jniPinger != null) {
            return;
        }
        try {
            this.m_jniPinger = new JniPinger();
            this.m_jniPinger.initialize4();
        }
        catch (Exception e) {
            this.m_v4Error = e;
            throw e;
        }
    }

    public synchronized void initialize6() throws Exception {
        if (this.s_pingTracker != null) {
            return;
        }
        final String name = "JNI-ICMPv6-" + this.m_pingerId;
        final IDBasedRequestLocator requestLocator = new IDBasedRequestLocator();
        try {
            this.m_jni6messenger = new Jni6IcmpMessenger(this.m_pingerId);
            this.s_pingTracker = (RequestTracker)Logging.withPrefix((String)"icmp", (Callable)new Callable<RequestTracker<Jni6PingRequest, Jni6PingResponse>>(){

                @Override
                public RequestTracker<Jni6PingRequest, Jni6PingResponse> call() throws Exception {
                    return new RequestTracker(name, (Messenger)Jni6Pinger.this.m_jni6messenger, (RequestLocator)requestLocator);
                }
            });
            this.s_pingTracker.start();
        }
        catch (IOException ioe) {
            this.m_v6Error = ioe;
            String errorMessage = this.m_v6Error.getMessage().toLowerCase();
            if (errorMessage.contains("permission denied") || errorMessage.contains("operation not permitted")) {
                LOG.error("Permission error received while attempting to open ICMP socket. See https://docs.opennms.com/ for information on configuring ICMP for non-root.");
            }
            throw ioe;
        }
        catch (RuntimeException rte) {
            this.m_v6Error = rte;
            throw rte;
        }
    }

    public boolean isV4Available() {
        try {
            this.initialize4();
        }
        catch (Throwable t) {
            LOG.trace("Failed to initialize IPv4", t);
        }
        if (this.m_jniPinger != null && this.m_v4Error == null) {
            return this.m_jniPinger.isV4Available();
        }
        return false;
    }

    public boolean isV6Available() {
        try {
            this.initialize6();
        }
        catch (Throwable t) {
            LOG.trace("Failed to initialize IPv6", t);
        }
        return this.s_pingTracker != null && this.m_v6Error == null;
    }

    public void ping(InetAddress host, long timeout, int retries, int packetsize, int sequenceId, PingResponseCallback cb) throws Exception {
        if (host instanceof Inet4Address) {
            this.initialize4();
            this.m_jniPinger.ping(host, timeout, retries, packetsize, sequenceId, cb);
        } else {
            this.initialize6();
            this.s_pingTracker.sendRequest((Request)new Jni6PingRequest((Inet6Address)host, this.m_pingerId, sequenceId, timeout, retries, packetsize, (PingResponseCallback)new LogPrefixPreservingPingResponseCallback(cb)));
        }
    }

    public void ping(InetAddress host, long timeout, int retries, int sequenceId, PingResponseCallback cb) throws Exception {
        if (host instanceof Inet4Address) {
            this.initialize4();
            this.m_jniPinger.ping(host, timeout, retries, 64, sequenceId, cb);
        } else {
            this.initialize6();
            this.s_pingTracker.sendRequest((Request)new Jni6PingRequest((Inet6Address)host, this.m_pingerId, sequenceId, timeout, retries, 64, (PingResponseCallback)new LogPrefixPreservingPingResponseCallback(cb)));
        }
    }

    public Number ping(InetAddress host, long timeout, int retries, int packetsize) throws Exception {
        SinglePingResponseCallback cb = new SinglePingResponseCallback(host);
        this.ping(host, timeout, retries, packetsize, 1, (PingResponseCallback)cb);
        cb.waitFor();
        cb.rethrowError();
        return cb.getResponseTime();
    }

    public Number ping(InetAddress host, long timeout, int retries) throws Exception {
        return this.ping(host, timeout, retries, 64);
    }

    public Number ping(InetAddress host) throws Exception {
        return this.ping(host, 800L, 2);
    }

    public List<Number> parallelPing(InetAddress host, int count, long timeout, long pingInterval, int size) throws Exception {
        if (host instanceof Inet4Address) {
            this.initialize4();
            return this.m_jniPinger.parallelPing(host, count, timeout, pingInterval);
        }
        this.initialize6();
        ParallelPingResponseCallback cb = new ParallelPingResponseCallback(count);
        long threadId = Jni6PingRequest.getNextTID();
        for (int seqNum = 0; seqNum < count; ++seqNum) {
            Jni6PingRequest request = new Jni6PingRequest((Inet6Address)host, this.m_pingerId, seqNum, threadId, timeout == 0L ? 800L : timeout, 0, size, (PingResponseCallback)cb);
            this.s_pingTracker.sendRequest((Request)request);
            Thread.sleep(pingInterval);
        }
        cb.waitFor();
        return cb.getResponseTimes();
    }

    public List<Number> parallelPing(InetAddress host, int count, long timeout, long pingInterval) throws Exception {
        return this.parallelPing(host, count, timeout, pingInterval, 64);
    }

    public void setTrafficClass(int tc) throws Exception {
        this.initialize4();
        this.initialize6();
        this.m_jniPinger.setTrafficClass(tc);
        this.m_jni6messenger.setTrafficClass(tc);
    }

    public void setAllowFragmentation(boolean allow) throws Exception {
        this.initialize4();
        this.initialize6();
        this.m_jniPinger.setAllowFragmentation(allow);
        this.m_jni6messenger.setAllowFragmentation(allow);
    }
}

