/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpTrapBuilder;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpTrapNotificationStrategy
implements NotificationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpTrapNotificationStrategy.class);
    private List<Argument> m_arguments;

    public int send(List<Argument> arguments) {
        block6: {
            this.m_arguments = arguments;
            String argVersion = this.getVersion();
            if (argVersion == null) {
                LOG.info("send: trapVersion paramenter is null, defaulting to \"v1\".");
                argVersion = "v1";
            }
            try {
                if (argVersion.equals("v1")) {
                    this.sendV1Trap();
                    break block6;
                }
                if (argVersion.equals("v2c") || argVersion.equals("v2")) {
                    this.sendV2Trap();
                    break block6;
                }
                if (argVersion.equals("v3")) {
                    LOG.info("send: Version3 not supported in notifications, yet, falling back to v2c.");
                    this.sendV2Trap();
                    break block6;
                }
                LOG.info("send: No version specified in first argument to notification.");
                return 1;
            }
            catch (Throwable e) {
                LOG.info("send: Exception trying to send trap. ", e);
                return 1;
            }
        }
        return 0;
    }

    private String getVersion() {
        return this.getSwitchValue("trapVersion");
    }

    public void sendV1Trap() throws Exception {
        SnmpV1TrapBuilder pdu = SnmpUtils.getV1TrapBuilder();
        pdu.setEnterprise(SnmpObjId.get((String)this.getEnterpriseId()));
        pdu.setGeneric(this.getGenericId());
        pdu.setSpecific(this.getSpecificId());
        pdu.setTimeStamp(0L);
        InetAddress agentAddress = this.getHostInetAddress();
        pdu.setAgentAddress(agentAddress);
        pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.4.1.5813.20.1"), SnmpUtils.getValueFactory().getOctetString(this.getVarbind().getBytes()));
        pdu.send(InetAddressUtils.str((InetAddress)agentAddress), this.getPort(), this.getCommunity());
    }

    public void sendV2Trap() throws Exception {
        SnmpObjId trapOID;
        SnmpObjId enterpriseId = SnmpObjId.get((String)this.getEnterpriseId());
        boolean isGeneric = false;
        if (SnmpObjId.get((String)".1.3.6.1.6.3.1.1.5").isPrefixOf(enterpriseId)) {
            isGeneric = true;
            trapOID = enterpriseId;
        } else {
            trapOID = SnmpObjId.get((SnmpObjId)enterpriseId, (SnmpObjId)new SnmpInstId(this.getSpecificId()));
        }
        SnmpTrapBuilder pdu = SnmpUtils.getV2TrapBuilder();
        pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.2.1.1.3.0"), SnmpUtils.getValueFactory().getTimeTicks(0L));
        pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.6.3.1.1.4.1.0"), SnmpUtils.getValueFactory().getObjectId(trapOID));
        if (isGeneric) {
            pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.6.3.1.1.4.3.0"), SnmpUtils.getValueFactory().getObjectId(enterpriseId));
        }
        pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.4.1.5813.20.1"), SnmpUtils.getValueFactory().getOctetString(this.getVarbind().getBytes()));
        pdu.send(InetAddressUtils.str((InetAddress)this.getHostInetAddress()), this.getPort(), this.getCommunity());
    }

    private InetAddress getHostInetAddress() throws UnknownHostException {
        String switchValue = this.getSwitchValue("trapHost");
        if (switchValue == null) {
            LOG.info("getHostInetAddress: trapHost not specified, defaulting to: \"127.0.0.1\".");
            switchValue = "127.0.0.1";
        } else {
            LOG.debug("getHostInetAddress: trapHost argument: {}", (Object)switchValue);
        }
        return InetAddressUtils.addr((String)switchValue);
    }

    private int getPort() {
        String switchValue = this.getSwitchValue("trapPort");
        if (switchValue == null) {
            LOG.info("getPort: trapPort argument not specified, defaulting to: \"162\".");
            return 162;
        }
        LOG.debug("getPort: trapPort argument: {}", (Object)Integer.parseInt(switchValue));
        return Integer.parseInt(switchValue);
    }

    private String getCommunity() {
        String switchValue = this.getSwitchValue("trapCommunity");
        if (switchValue == null) {
            LOG.info("getCommunity: trapCommunity not specified, defaulting to: \"public\".");
            switchValue = "public";
        } else {
            LOG.debug("getCommunity: trapCommunity argument: {}", (Object)switchValue);
        }
        return switchValue;
    }

    private String getEnterpriseId() {
        String switchValue = this.getSwitchValue("trapEnterprise");
        if (switchValue == null) {
            LOG.info("getEnterpriseId: trapEnterprise not specified, defaulting to: \".1.3.6.1.4.1.5813\".");
            switchValue = ".1.3.6.1.4.1.5813";
        } else {
            LOG.debug("getEnterpriseId: trapEnterprise argument: {}", (Object)switchValue);
        }
        return switchValue;
    }

    private int getGenericId() {
        String switchValue = this.getSwitchValue("trapGeneric");
        if (switchValue == null) {
            LOG.info("getGenericId: trapGeneric argument not specified, defaulting to: \"6\".");
            return 6;
        }
        LOG.debug("getGenericId: trapGeneric argument: {}", (Object)switchValue);
        return Integer.parseInt(switchValue);
    }

    private int getSpecificId() {
        String switchValue = this.getSwitchValue("trapSpecific");
        if (switchValue == null) {
            LOG.info("getSpecificId: trapSpecific argument not specified, defaulting to: \"1\".");
            return 1;
        }
        LOG.debug("getSpecificId: trapSpecific argument: {}", (Object)Integer.parseInt(switchValue));
        return Integer.parseInt(switchValue);
    }

    private String getVarbind() {
        String switchValue = this.getSwitchValue("trapVarbind");
        if (switchValue == null) {
            LOG.info("getVarbind: trapVarbind argument not specified, defaulting to: \"OpenNMS Trap Notification\".");
            return "OpenNMS Trap Notification";
        }
        LOG.debug("getVarbind: trapVarbind argument: {}", (Object)switchValue);
        return switchValue;
    }

    private String getSwitchValue(String argSwitch) {
        String value = null;
        for (Argument arg : this.m_arguments) {
            if (!arg.getSwitch().equals(argSwitch)) continue;
            value = arg.getValue();
        }
        if (value != null && value.equals("")) {
            value = null;
        }
        return value;
    }
}

