/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.exolab.castor.types;

import java.text.ParseException;
import java.util.GregorianCalendar;
import org.opennms.shaded.jasper.org.exolab.castor.types.DateTimeBase;

public class Date
extends DateTimeBase {
    private static final long serialVersionUID = -1634875709019365137L;
    private static final String BAD_DATE = "Bad Date format: ";

    public Date() {
    }

    public Date(short[] values) {
        this.setValues(values);
    }

    public Date(long dateAsLong) {
        this(new java.util.Date(dateAsLong));
    }

    public Date(java.util.Date dateRef) {
        GregorianCalendar tempCalendar = new GregorianCalendar();
        tempCalendar.setTime(dateRef);
        this.setCentury((short)(tempCalendar.get(1) / 100));
        this.setYear((short)(tempCalendar.get(1) % 100));
        this.setMonth((short)(tempCalendar.get(2) + 1));
        this.setDay((short)tempCalendar.get(5));
    }

    public Date(String date) throws ParseException {
        Date.parseDateInternal(date, this);
    }

    @Override
    public void setValues(short[] values) {
        if (values.length != 4) {
            throw new IllegalArgumentException("Date#setValues: not the right number of values");
        }
        this.setCentury(values[0]);
        this.setYear(values[1]);
        this.setMonth(values[2]);
        this.setDay(values[3]);
    }

    @Override
    public short[] getValues() {
        short[] result = new short[]{this.getCentury(), this.getYear(), this.getMonth(), this.getDay()};
        return result;
    }

    @Override
    public java.util.Date toDate() {
        GregorianCalendar calendar = new GregorianCalendar(this.getCentury() * 100 + this.getYear(), this.getMonth() - 1, this.getDay());
        this.setDateFormatTimeZone(calendar);
        return calendar.getTime();
    }

    public long toLong() {
        return this.toDate().getTime();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        this.appendDateString(result);
        this.appendTimeZoneString(result);
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return Date.parseDate(str);
    }

    public static Date parseDate(String str) throws ParseException {
        Date result = new Date();
        return Date.parseDateInternal(str, result);
    }

    private static Date parseDateInternal(String str, Date result) throws ParseException {
        int idx;
        char[] chars;
        if (str == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        if (result == null) {
            result = new Date();
        }
        if ((chars = str.toCharArray())[idx = 0] == '-') {
            ++idx;
            result.setNegative();
        }
        if (!(Character.isDigit(chars[idx]) && Character.isDigit(chars[idx + 1]) && Character.isDigit(chars[idx + 2]) && Character.isDigit(chars[idx + 3]))) {
            throw new ParseException("Bad Date format: '" + str + "'\nThe Year must be 4 digits long", idx);
        }
        short value1 = (short)((chars[idx] - 48) * 10 + (chars[idx + 1] - 48));
        short value2 = (short)((chars[idx + 2] - 48) * 10 + (chars[idx + 3] - 48));
        if (value1 == 0 && value2 == 0) {
            throw new ParseException(BAD_DATE + str + "\n'0000' is not allowed as a year.", idx);
        }
        result.setCentury(value1);
        result.setYear(value2);
        if (chars[idx += 4] != '-') {
            throw new ParseException("Bad Date format: '" + str + "'\n '-' " + " is wrongly placed.", idx);
        }
        if (!Character.isDigit(chars[++idx]) || !Character.isDigit(chars[idx + 1])) {
            throw new ParseException("Bad Date format: '" + str + "'\nThe Month must be 2 digits long", idx);
        }
        value1 = (short)((chars[idx] - 48) * 10 + (chars[idx + 1] - 48));
        result.setMonth(value1);
        if (chars[idx += 2] != '-') {
            throw new ParseException("Bad Date format: '" + str + "'\n '-' " + " is wrongly placed.", idx);
        }
        if (!Character.isDigit(chars[++idx]) || !Character.isDigit(chars[idx + 1])) {
            throw new ParseException("Bad Date format: '" + str + "'\nThe Day must be 2 digits long", idx);
        }
        value1 = (short)((chars[idx] - 48) * 10 + (chars[idx + 1] - 48));
        result.setDay(value1);
        Date.parseTimeZone(str, result, chars, idx += 2, BAD_DATE);
        return result;
    }

    @Override
    public boolean hasHour() {
        return false;
    }

    @Override
    public short getHour() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.Date does not have an Hour field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setHour(short hour) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.Date does not have an Hour field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public boolean hasMinute() {
        return false;
    }

    @Override
    public short getMinute() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.Date does not have a Minute field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setMinute(short minute) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.Date does not have a Minute field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public boolean hasSeconds() {
        return false;
    }

    @Override
    public short getSeconds() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.Date does not have a Seconds field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setSecond(short second) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.Date does not have a Seconds field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public boolean hasMilli() {
        return false;
    }

    @Override
    public short getMilli() {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.Date does not have a Milliseconds field.";
        throw new UnsupportedOperationException(err);
    }

    @Override
    public void setMilliSecond(short millisecond) {
        String err = "org.opennms.shaded.jasper.org.exolab.castor.types.Date does not have a Milliseconds field.";
        throw new UnsupportedOperationException(err);
    }
}

