/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.com.lowagie.text.pdf;

import java.awt.color.ICC_Profile;
import org.opennms.shaded.jasper.com.lowagie.text.ExceptionConverter;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfException;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfName;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfNumber;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfStream;

public class PdfICCBased
extends PdfStream {
    public PdfICCBased(ICC_Profile iCC_Profile) {
        this(iCC_Profile, -1);
    }

    public PdfICCBased(ICC_Profile iCC_Profile, int n) {
        try {
            int n2 = iCC_Profile.getNumComponents();
            switch (n2) {
                case 1: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICEGRAY);
                    break;
                }
                case 3: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICERGB);
                    break;
                }
                case 4: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICECMYK);
                    break;
                }
                default: {
                    throw new PdfException(n2 + " component(s) is not supported in PDF1.4");
                }
            }
            this.put(PdfName.N, new PdfNumber(n2));
            this.bytes = iCC_Profile.getData();
            this.flateCompress(n);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }
}

