/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrivialTimeMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(TrivialTimeMonitor.class);
    private static final String DEFAULT_PROTOCOL = "tcp";
    private static final int DEFAULT_PORT = 37;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int DEFAULT_ALLOWED_SKEW = 30;
    private static final int EPOCH_ADJ_FACTOR = 2085978496;
    private static final boolean DEFAULT_PERSIST_SKEW = false;

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)37);
        InetAddress ipAddr = svc.getAddress();
        LOG.debug("poll: address = {}, port = {}, tracker = {}", new Object[]{InetAddressUtils.str((InetAddress)ipAddr), port, tracker});
        int allowedSkew = ParameterMap.getKeyedInteger(parameters, (String)"allowed-skew", (int)30);
        boolean persistSkew = ParameterMap.getKeyedBoolean(parameters, (String)"persist-skew", (boolean)false);
        PollStatus serviceStatus = PollStatus.unavailable();
        String protocol = ParameterMap.getKeyedString(parameters, (String)"protocol", (String)DEFAULT_PROTOCOL).toLowerCase();
        if (!protocol.equalsIgnoreCase(DEFAULT_PROTOCOL) && !protocol.equalsIgnoreCase("udp")) {
            throw new IllegalArgumentException("Unsupported protocol, only TCP and UDP currently supported");
        }
        if (protocol.equalsIgnoreCase("udp")) {
            LOG.warn("UDP support is largely untested");
        }
        if (protocol.equalsIgnoreCase(DEFAULT_PROTOCOL)) {
            serviceStatus = this.pollTimeTcp(svc, parameters, serviceStatus, tracker, ipAddr, port, allowedSkew, persistSkew);
        } else if (protocol.equalsIgnoreCase("udp")) {
            serviceStatus = this.pollTimeUdp(svc, parameters, serviceStatus, tracker, ipAddr, port, allowedSkew, persistSkew);
        }
        return serviceStatus;
    }

    public void storeResult(PollStatus serviceStatus, Number skew, Double responseTime, boolean persistSkew) {
        LinkedHashMap<String, Number> skewProps = new LinkedHashMap<String, Number>();
        if (persistSkew) {
            skewProps.put("skew", skew);
            LOG.debug("persistSkew: Persisting time skew (value = {}) for this node", (Object)skew);
        }
        skewProps.put("response-time", responseTime);
        serviceStatus.setProperties(skewProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus pollTimeTcp(MonitoredService svc, Map<String, Object> parameters, PollStatus serviceStatus, TimeoutTracker tracker, InetAddress ipv4Addr, int port, int allowedSkew, boolean persistSkew) {
        int localTime = 0;
        int remoteTime = 0;
        boolean gotTime = false;
        tracker.reset();
        while (tracker.shouldRetry() && !gotTime) {
            block34: {
                String reason;
                Socket socket = null;
                try {
                    tracker.startAttempt();
                    socket = new Socket();
                    socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                    socket.setSoTimeout(tracker.getSoTimeout());
                    LOG.debug("Connected to host: {} on TCP port: {}", (Object)ipv4Addr, (Object)port);
                    byte[] timeBytes = new byte[4];
                    ByteBuffer timeByteBuffer = ByteBuffer.wrap(timeBytes);
                    int bytesRead = socket.getInputStream().read(timeBytes);
                    if (bytesRead != 4) break block34;
                    LOG.debug("pollTimeTcp: bytes read = {}", (Object)bytesRead);
                    try {
                        remoteTime = timeByteBuffer.getInt();
                    }
                    catch (BufferUnderflowException bue) {
                        LOG.error("Encountered buffer underflow while reading time from remote socket.");
                        remoteTime = 0;
                        serviceStatus = PollStatus.unavailable("Failed to read a valid time from remote host.");
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                            break block34;
                        }
                        catch (IOException e) {
                            e.fillInStackTrace();
                            LOG.debug("pollTimeTcp: Error closing socket.", (Throwable)e);
                        }
                        break block34;
                    }
                    localTime = (int)(System.currentTimeMillis() / 1000L) - 2085978496;
                    gotTime = true;
                    serviceStatus = this.qualifyTime(remoteTime, localTime, allowedSkew, serviceStatus, tracker.elapsedTimeInMillis(), persistSkew);
                }
                catch (NoRouteToHostException e) {
                    reason = "No route to host exception for address " + InetAddressUtils.str((InetAddress)ipv4Addr);
                    LOG.debug(reason, (Throwable)e);
                    serviceStatus = PollStatus.unavailable(reason);
                }
                catch (InterruptedIOException e) {
                    reason = "did not connect to host with " + String.valueOf(tracker);
                    LOG.debug(reason);
                    serviceStatus = PollStatus.unavailable(reason);
                }
                catch (ConnectException e) {
                    reason = "Connection exception for address: " + String.valueOf(ipv4Addr);
                    LOG.debug(reason, (Throwable)e);
                    serviceStatus = PollStatus.unavailable(reason);
                }
                catch (IOException e) {
                    reason = "IOException while polling address: " + String.valueOf(ipv4Addr);
                    LOG.debug(reason, (Throwable)e);
                    serviceStatus = PollStatus.unavailable(reason);
                }
                finally {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        e.fillInStackTrace();
                        LOG.debug("pollTimeTcp: Error closing socket.", (Throwable)e);
                    }
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus pollTimeUdp(MonitoredService svc, Map<String, Object> parameters, PollStatus serviceStatus, TimeoutTracker tracker, InetAddress ipv4Addr, int port, int allowedSkew, boolean persistSkew) {
        int localTime = 0;
        int remoteTime = 0;
        boolean gotTime = false;
        tracker.reset();
        while (tracker.shouldRetry() && !gotTime) {
            block18: {
                String reason;
                String hostAddress = InetAddressUtils.str((InetAddress)ipv4Addr);
                try (DatagramSocket socket = null;){
                    tracker.startAttempt();
                    socket = new DatagramSocket();
                    socket.setSoTimeout(tracker.getSoTimeout());
                    LOG.debug("Requesting time from host: {} on UDP port: {}", (Object)ipv4Addr, (Object)port);
                    socket.send(new DatagramPacket(new byte[0], 0, ipv4Addr, port));
                    byte[] timeBytes = new byte[4];
                    ByteBuffer timeByteBuffer = ByteBuffer.wrap(timeBytes);
                    DatagramPacket timePacket = new DatagramPacket(timeBytes, timeBytes.length, ipv4Addr, port);
                    socket.receive(timePacket);
                    int bytesRead = timePacket.getLength();
                    if (bytesRead != 4) break block18;
                    LOG.debug("pollTimeUdp: bytes read = {}", (Object)bytesRead);
                    try {
                        remoteTime = timeByteBuffer.getInt();
                    }
                    catch (BufferUnderflowException bue) {
                        LOG.error("Encountered buffer underflow while reading time from remote socket.");
                        remoteTime = 0;
                        serviceStatus = PollStatus.unavailable("Failed to read a valid time from remote host.");
                        if (socket != null) {
                            socket.close();
                        }
                        break block18;
                    }
                    localTime = (int)(System.currentTimeMillis() / 1000L) - 2085978496;
                    gotTime = true;
                    serviceStatus = this.qualifyTime(remoteTime, localTime, allowedSkew, serviceStatus, tracker.elapsedTimeInMillis(), persistSkew);
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    private PollStatus qualifyTime(int remoteTime, int localTime, int allowedSkew, PollStatus serviceStatus, double responseTime, boolean persistSkew) {
        String reason;
        LOG.debug("qualifyTime: checking remote time {} against local time {} with max skew of {}", new Object[]{remoteTime, localTime, allowedSkew});
        if (localTime - remoteTime > allowedSkew || remoteTime - localTime > allowedSkew) {
            reason = "Remote time is " + (localTime > remoteTime ? localTime - remoteTime + " seconds slow" : remoteTime - localTime + " seconds fast");
            LOG.debug(reason);
            serviceStatus = PollStatus.unavailable(reason);
        }
        if (localTime > remoteTime && localTime - remoteTime > allowedSkew) {
            reason = "Remote time is " + (localTime - remoteTime) + " seconds behind local, more than the allowable " + allowedSkew;
            LOG.debug(reason);
            serviceStatus = PollStatus.unavailable(reason);
        } else if (remoteTime > localTime && remoteTime - localTime > allowedSkew) {
            reason = "Remote time is " + (remoteTime - localTime) + " seconds ahead of local, more than the allowable " + allowedSkew;
            LOG.debug(reason);
            serviceStatus = PollStatus.unavailable(reason);
        } else {
            serviceStatus = PollStatus.available();
        }
        this.storeResult(serviceStatus, remoteTime - localTime, responseTime, persistSkew);
        return serviceStatus;
    }
}

