/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.fieldgroup;

import com.vaadin.annotations.PropertyId;
import com.vaadin.util.ReflectTools;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.fieldgroup.Caption;
import com.vaadin.v7.data.fieldgroup.DefaultFieldGroupFieldFactory;
import com.vaadin.v7.data.fieldgroup.FieldGroupFieldFactory;
import com.vaadin.v7.data.util.TransactionalPropertyWrapper;
import com.vaadin.v7.ui.AbstractField;
import com.vaadin.v7.ui.DefaultFieldFactory;
import com.vaadin.v7.ui.Field;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Deprecated
public class FieldGroup
implements Serializable {
    private Item itemDataSource;
    private boolean buffered = true;
    private boolean enabled = true;
    private boolean readOnly = false;
    private Map<Object, Field<?>> propertyIdToField = new HashMap();
    private LinkedHashMap<Field<?>, Object> fieldToPropertyId = new LinkedHashMap();
    private List<CommitHandler> commitHandlers = new ArrayList<CommitHandler>();
    private FieldGroupFieldFactory fieldFactory = DefaultFieldGroupFieldFactory.get();

    public FieldGroup() {
    }

    public FieldGroup(Item itemDataSource) {
        this.setItemDataSource(itemDataSource);
    }

    public void setItemDataSource(Item itemDataSource) {
        this.itemDataSource = itemDataSource;
        this.bindFields();
    }

    protected void bindFields() {
        for (Field<?> f : this.fieldToPropertyId.keySet()) {
            this.bind(f, this.fieldToPropertyId.get(f));
        }
    }

    public Item getItemDataSource() {
        return this.itemDataSource;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void setBuffered(boolean buffered) {
        if (buffered == this.buffered) {
            return;
        }
        this.buffered = buffered;
        for (Field<?> field : this.getFields()) {
            field.setBuffered(buffered);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean fieldsEnabled) {
        this.enabled = fieldsEnabled;
        for (Field<?> field : this.getFields()) {
            field.setEnabled(fieldsEnabled);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean fieldsReadOnly) {
        this.readOnly = fieldsReadOnly;
        for (Field<?> field : this.getFields()) {
            if (field.getPropertyDataSource() == null || !field.getPropertyDataSource().isReadOnly()) {
                field.setReadOnly(fieldsReadOnly);
                continue;
            }
            field.setReadOnly(true);
        }
    }

    public Collection<Field<?>> getFields() {
        return this.fieldToPropertyId.keySet();
    }

    public void bind(Field<?> field, Object propertyId) throws BindException {
        this.throwIfFieldIsNull(field, propertyId);
        this.throwIfPropertyIdAlreadyBound(field, propertyId);
        this.fieldToPropertyId.put(field, propertyId);
        this.propertyIdToField.put(propertyId, field);
        if (this.itemDataSource == null) {
            this.clearField(field);
            return;
        }
        field.setPropertyDataSource(this.wrapInTransactionalProperty(this.getItemProperty(propertyId)));
        this.configureField(field);
    }

    protected void clearField(Field<?> field) {
        field.setPropertyDataSource(null);
        boolean fieldReadOnly = field.isReadOnly();
        if (!fieldReadOnly) {
            field.clear();
        } else {
            field.setReadOnly(false);
            field.clear();
            field.setReadOnly(true);
        }
    }

    protected <T> Property.Transactional<T> wrapInTransactionalProperty(Property<T> itemProperty) {
        return new TransactionalPropertyWrapper<T>(itemProperty);
    }

    private void throwIfFieldIsNull(Field<?> field, Object propertyId) {
        if (field == null) {
            throw new BindException(String.format("Cannot bind property id '%s' to a null field.", propertyId));
        }
    }

    private void throwIfPropertyIdAlreadyBound(Field<?> field, Object propertyId) {
        if (this.propertyIdToField.containsKey(propertyId) && this.propertyIdToField.get(propertyId) != field) {
            throw new BindException("Property id " + propertyId + " is already bound to another field");
        }
    }

    protected Property getItemProperty(Object propertyId) throws BindException {
        Item item = this.getItemDataSource();
        if (item == null) {
            throw new BindException("Could not lookup property with id " + propertyId + " as no item has been set");
        }
        Property p = item.getItemProperty(propertyId);
        if (p == null) {
            throw new BindException("A property with id " + propertyId + " was not found in the item");
        }
        return p;
    }

    public void unbind(Field<?> field) throws BindException {
        Object propertyId = this.fieldToPropertyId.get(field);
        if (propertyId == null) {
            throw new BindException("The given field is not part of this FieldBinder");
        }
        TransactionalPropertyWrapper wrapper = null;
        Property fieldDataSource = field.getPropertyDataSource();
        if (fieldDataSource instanceof TransactionalPropertyWrapper) {
            wrapper = (TransactionalPropertyWrapper)fieldDataSource;
            fieldDataSource = ((TransactionalPropertyWrapper)fieldDataSource).getWrappedProperty();
        }
        if (this.getItemDataSource() != null && fieldDataSource == this.getItemProperty(propertyId)) {
            if (null != wrapper) {
                wrapper.detachFromProperty();
            }
            field.setPropertyDataSource(null);
        }
        this.fieldToPropertyId.remove(field);
        this.propertyIdToField.remove(propertyId);
    }

    protected void configureField(Field<?> field) {
        field.setBuffered(this.isBuffered());
        field.setEnabled(this.isEnabled());
        if (field.getPropertyDataSource().isReadOnly()) {
            field.setReadOnly(true);
        } else {
            field.setReadOnly(this.isReadOnly());
        }
    }

    protected Class<?> getPropertyType(Object propertyId) throws BindException {
        if (this.getItemDataSource() == null) {
            throw new BindException("Property type for '" + propertyId + "' could not be determined. No item data source has been set.");
        }
        Property p = this.getItemDataSource().getItemProperty(propertyId);
        if (p == null) {
            throw new BindException("Property type for '" + propertyId + "' could not be determined. No property with that id was found.");
        }
        return p.getType();
    }

    public Collection<Object> getBoundPropertyIds() {
        return Collections.unmodifiableCollection(this.propertyIdToField.keySet());
    }

    public Collection<Object> getUnboundPropertyIds() {
        if (this.getItemDataSource() == null) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> unboundPropertyIds = new ArrayList<Object>();
        unboundPropertyIds.addAll(this.getItemDataSource().getItemPropertyIds());
        unboundPropertyIds.removeAll(this.propertyIdToField.keySet());
        return unboundPropertyIds;
    }

    public void commit() throws CommitException {
        if (!this.isBuffered()) {
            return;
        }
        this.startTransactions();
        try {
            this.firePreCommitEvent();
            Map<Field<?>, Validator.InvalidValueException> invalidValueExceptions = this.commitFields();
            if (!invalidValueExceptions.isEmpty()) {
                throw new FieldGroupInvalidValueException(invalidValueExceptions);
            }
            this.firePostCommitEvent();
            this.commitTransactions();
        }
        catch (Exception e) {
            this.rollbackTransactions();
            throw new CommitException("Commit failed", this, e);
        }
    }

    private Map<Field<?>, Validator.InvalidValueException> commitFields() {
        HashMap invalidValueExceptions = new HashMap();
        for (Field<?> f : this.fieldToPropertyId.keySet()) {
            try {
                f.commit();
            }
            catch (Validator.InvalidValueException e) {
                invalidValueExceptions.put(f, e);
            }
        }
        return invalidValueExceptions;
    }

    private void startTransactions() throws CommitException {
        for (Field<?> f : this.fieldToPropertyId.keySet()) {
            Property.Transactional property = (Property.Transactional)f.getPropertyDataSource();
            if (property == null) {
                throw new CommitException("Property \"" + this.fieldToPropertyId.get(f) + "\" not bound to datasource.");
            }
            property.startTransaction();
        }
    }

    private void commitTransactions() {
        for (Field<?> f : this.fieldToPropertyId.keySet()) {
            ((Property.Transactional)f.getPropertyDataSource()).commit();
        }
    }

    private void rollbackTransactions() {
        for (Field<?> f : this.fieldToPropertyId.keySet()) {
            try {
                ((Property.Transactional)f.getPropertyDataSource()).rollback();
            }
            catch (Exception exception) {}
        }
    }

    private void firePreCommitEvent() throws CommitException {
        CommitHandler[] handlers;
        for (CommitHandler handler : handlers = this.commitHandlers.toArray(new CommitHandler[this.commitHandlers.size()])) {
            handler.preCommit(new CommitEvent(this));
        }
    }

    private void firePostCommitEvent() throws CommitException {
        CommitHandler[] handlers;
        for (CommitHandler handler : handlers = this.commitHandlers.toArray(new CommitHandler[this.commitHandlers.size()])) {
            handler.postCommit(new CommitEvent(this));
        }
    }

    public void discard() {
        for (Field<?> f : this.fieldToPropertyId.keySet()) {
            try {
                f.discard();
            }
            catch (Exception exception) {}
        }
    }

    public Field<?> getField(Object propertyId) {
        return this.propertyIdToField.get(propertyId);
    }

    public Object getPropertyId(Field<?> field) {
        return this.fieldToPropertyId.get(field);
    }

    public void addCommitHandler(CommitHandler commitHandler) {
        this.commitHandlers.add(commitHandler);
    }

    public void removeCommitHandler(CommitHandler commitHandler) {
        this.commitHandlers.remove(commitHandler);
    }

    protected Collection<CommitHandler> getCommitHandlers() {
        return Collections.unmodifiableCollection(this.commitHandlers);
    }

    public boolean isValid() {
        try {
            for (Field<?> field : this.getFields()) {
                field.validate();
            }
            return true;
        }
        catch (Validator.InvalidValueException e) {
            return false;
        }
    }

    public boolean isModified() {
        for (Field<?> field : this.getFields()) {
            if (!field.isModified()) continue;
            return true;
        }
        return false;
    }

    public FieldGroupFieldFactory getFieldFactory() {
        return this.fieldFactory;
    }

    public void setFieldFactory(FieldGroupFieldFactory fieldFactory) {
        this.fieldFactory = fieldFactory;
    }

    public void bindMemberFields(Object objectWithMemberFields) throws BindException {
        this.buildAndBindMemberFields(objectWithMemberFields, false);
    }

    public void buildAndBindMemberFields(Object objectWithMemberFields) throws BindException {
        this.buildAndBindMemberFields(objectWithMemberFields, true);
    }

    protected void buildAndBindMemberFields(Object objectWithMemberFields, boolean buildFields) throws BindException {
        Class<?> objectClass = objectWithMemberFields.getClass();
        for (java.lang.reflect.Field memberField : FieldGroup.getFieldsInDeclareOrder(objectClass)) {
            Field<Object> field;
            Class<?> propertyType;
            if (!Field.class.isAssignableFrom(memberField.getType())) continue;
            PropertyId propertyIdAnnotation = memberField.getAnnotation(PropertyId.class);
            Class<?> fieldType = memberField.getType();
            Object propertyId = null;
            if (propertyIdAnnotation != null) {
                propertyId = propertyIdAnnotation.value();
            } else {
                try {
                    propertyId = this.findPropertyId(memberField);
                }
                catch (SearchException e) {
                    continue;
                }
                if (propertyId == null) continue;
            }
            try {
                propertyType = this.getPropertyType(propertyId);
            }
            catch (BindException e) {
                continue;
            }
            try {
                field = (Field)ReflectTools.getJavaFieldValue((Object)objectWithMemberFields, (java.lang.reflect.Field)memberField, Field.class);
            }
            catch (Exception e) {
                continue;
            }
            if (field == null && buildFields) {
                Caption captionAnnotation = memberField.getAnnotation(Caption.class);
                String caption = captionAnnotation != null ? captionAnnotation.value() : DefaultFieldFactory.createCaptionByPropertyId(propertyId);
                field = this.build(caption, propertyType, fieldType);
                try {
                    ReflectTools.setJavaFieldValue((Object)objectWithMemberFields, (java.lang.reflect.Field)memberField, (Object)field);
                }
                catch (IllegalArgumentException e) {
                    throw new BindException("Could not assign value to field '" + memberField.getName() + "'", e);
                }
                catch (IllegalAccessException e) {
                    throw new BindException("Could not assign value to field '" + memberField.getName() + "'", e);
                }
                catch (InvocationTargetException e) {
                    throw new BindException("Could not assign value to field '" + memberField.getName() + "'", e);
                }
            }
            if (field == null) continue;
            this.bind(field, propertyId);
        }
    }

    protected Object findPropertyId(java.lang.reflect.Field memberField) {
        String fieldName = memberField.getName();
        if (this.getItemDataSource() == null) {
            throw new SearchException("Property id type for field '" + fieldName + "' could not be determined. No item data source has been set.");
        }
        Item dataSource = this.getItemDataSource();
        if (dataSource.getItemProperty(fieldName) != null) {
            return fieldName;
        }
        String minifiedFieldName = FieldGroup.minifyFieldName(fieldName);
        for (Object itemPropertyId : dataSource.getItemPropertyIds()) {
            String itemPropertyName;
            if (!(itemPropertyId instanceof String) || !minifiedFieldName.equals(FieldGroup.minifyFieldName(itemPropertyName = (String)itemPropertyId))) continue;
            return itemPropertyName;
        }
        return null;
    }

    protected static String minifyFieldName(String fieldName) {
        return fieldName.toLowerCase(Locale.ROOT).replace("_", "");
    }

    public Field<?> buildAndBind(Object propertyId) throws BindException {
        String caption = DefaultFieldFactory.createCaptionByPropertyId(propertyId);
        return this.buildAndBind(caption, propertyId);
    }

    public Field<?> buildAndBind(String caption, Object propertyId) throws BindException {
        return this.buildAndBind(caption, propertyId, Field.class);
    }

    public <T extends Field> T buildAndBind(String caption, Object propertyId, Class<T> fieldType) throws BindException {
        Class<?> type = this.getPropertyType(propertyId);
        T field = this.build(caption, type, fieldType);
        this.bind((Field<?>)field, propertyId);
        return field;
    }

    protected <T extends Field> T build(String caption, Class<?> dataType, Class<T> fieldType) throws BindException {
        T field = this.getFieldFactory().createField(dataType, fieldType);
        if (field == null) {
            throw new BindException("Unable to build a field of type " + fieldType.getName() + " for editing " + dataType.getName());
        }
        field.setCaption(caption);
        return field;
    }

    protected static List<java.lang.reflect.Field> getFieldsInDeclareOrder(Class searchClass) {
        ArrayList<java.lang.reflect.Field> memberFieldInOrder = new ArrayList<java.lang.reflect.Field>();
        while (searchClass != null) {
            for (java.lang.reflect.Field memberField : searchClass.getDeclaredFields()) {
                memberFieldInOrder.add(memberField);
            }
            searchClass = searchClass.getSuperclass();
        }
        return memberFieldInOrder;
    }

    public void clear() {
        for (Field<?> f : this.getFields()) {
            if (!(f instanceof AbstractField)) continue;
            ((AbstractField)f).clear();
        }
    }

    @Deprecated
    public static class SearchException
    extends RuntimeException {
        public SearchException(String message) {
            super(message);
        }

        public SearchException(String message, Throwable t) {
            super(message, t);
        }
    }

    @Deprecated
    public static class BindException
    extends RuntimeException {
        public BindException(String message) {
            super(message);
        }

        public BindException(String message, Throwable t) {
            super(message, t);
        }
    }

    @Deprecated
    public static class CommitException
    extends Exception {
        private FieldGroup fieldGroup;

        public CommitException() {
        }

        public CommitException(String message, FieldGroup fieldGroup, Throwable cause) {
            super(message, cause);
            this.fieldGroup = fieldGroup;
        }

        public CommitException(String message, Throwable cause) {
            super(message, cause);
        }

        public CommitException(String message) {
            super(message);
        }

        public CommitException(Throwable cause) {
            super(cause);
        }

        public Map<Field<?>, Validator.InvalidValueException> getInvalidFields() {
            if (this.getCause() instanceof FieldGroupInvalidValueException) {
                return ((FieldGroupInvalidValueException)this.getCause()).getInvalidFields();
            }
            return new HashMap();
        }

        public FieldGroup getFieldGroup() {
            return this.fieldGroup;
        }
    }

    @Deprecated
    public static class CommitEvent
    implements Serializable {
        private FieldGroup fieldBinder;

        private CommitEvent(FieldGroup fieldBinder) {
            this.fieldBinder = fieldBinder;
        }

        public FieldGroup getFieldBinder() {
            return this.fieldBinder;
        }
    }

    @Deprecated
    public static interface CommitHandler
    extends Serializable {
        public void preCommit(CommitEvent var1) throws CommitException;

        public void postCommit(CommitEvent var1) throws CommitException;
    }

    @Deprecated
    public static class FieldGroupInvalidValueException
    extends Validator.InvalidValueException {
        private Map<Field<?>, Validator.InvalidValueException> invalidValueExceptions;

        public FieldGroupInvalidValueException(Map<Field<?>, Validator.InvalidValueException> invalidValueExceptions) {
            super(null, invalidValueExceptions.values().toArray(new Validator.InvalidValueException[invalidValueExceptions.size()]));
            this.invalidValueExceptions = invalidValueExceptions;
        }

        public Map<Field<?>, Validator.InvalidValueException> getInvalidFields() {
            return this.invalidValueExceptions;
        }
    }
}

