/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.picking;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.LinkedHashSet;

public class ShapePickSupport<V, E>
implements GraphElementAccessor<V, E> {
    protected float pickSize;
    protected VisualizationServer<V, E> vv;
    protected Style style = Style.CENTERED;

    public ShapePickSupport(VisualizationServer<V, E> vv, float pickSize) {
        this.vv = vv;
        this.pickSize = pickSize;
    }

    public ShapePickSupport(VisualizationServer<V, E> vv) {
        this.vv = vv;
        this.pickSize = 2.0f;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    @Override
    public V getVertex(Layout<V, E> layout, double x, double y) {
        V closest = null;
        double minDistance = Double.MAX_VALUE;
        Point2D ip = this.vv.getRenderContext().getMultiLayerTransformer().inverseTransform(Layer.VIEW, new Point2D.Double(x, y));
        x = ip.getX();
        y = ip.getY();
        while (true) {
            try {
                for (V v : this.getFilteredVertices(layout)) {
                    double dy;
                    double oy;
                    double ox;
                    Shape shape = (Shape)this.vv.getRenderContext().getVertexShapeTransformer().apply(v);
                    Point2D p = (Point2D)layout.apply(v);
                    if (p == null || !shape.contains(ox = x - (p = this.vv.getRenderContext().getMultiLayerTransformer().transform(Layer.LAYOUT, p)).getX(), oy = y - p.getY())) continue;
                    if (this.style == Style.LOWEST) {
                        return v;
                    }
                    if (this.style == Style.HIGHEST) {
                        closest = v;
                        continue;
                    }
                    Rectangle2D bounds = shape.getBounds2D();
                    double dx = bounds.getCenterX() - ox;
                    double dist = dx * dx + (dy = bounds.getCenterY() - oy) * dy;
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                    closest = v;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }

    @Override
    public Collection<V> getVertices(Layout<V, E> layout, Shape shape) {
        HashSet<V> pickedVertices = new HashSet<V>();
        shape = this.vv.getRenderContext().getMultiLayerTransformer().inverseTransform(Layer.VIEW, shape);
        while (true) {
            try {
                for (V v : this.getFilteredVertices(layout)) {
                    Point2D p = (Point2D)layout.apply(v);
                    if (p == null || !shape.contains(p = this.vv.getRenderContext().getMultiLayerTransformer().transform(Layer.LAYOUT, p))) continue;
                    pickedVertices.add(v);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return pickedVertices;
    }

    @Override
    public E getEdge(Layout<V, E> layout, double x, double y) {
        Point2D ip = this.vv.getRenderContext().getMultiLayerTransformer().inverseTransform(Layer.VIEW, new Point2D.Double(x, y));
        x = ip.getX();
        y = ip.getY();
        Rectangle2D.Float pickArea = new Rectangle2D.Float((float)x - this.pickSize / 2.0f, (float)y - this.pickSize / 2.0f, this.pickSize, this.pickSize);
        E closest = null;
        double minDistance = Double.MAX_VALUE;
        while (true) {
            try {
                for (E e : this.getFilteredEdges(layout)) {
                    float dy;
                    float dx;
                    float dist;
                    Shape edgeShape = this.getTransformedEdgeShape(layout, e);
                    if (edgeShape == null || !edgeShape.intersects(pickArea)) continue;
                    float cx = 0.0f;
                    float cy = 0.0f;
                    float[] f = new float[6];
                    PathIterator pi = new GeneralPath(edgeShape).getPathIterator(null);
                    if (!pi.isDone()) {
                        pi.next();
                        pi.currentSegment(f);
                        cx = f[0];
                        cy = f[1];
                        if (!pi.isDone()) {
                            pi.currentSegment(f);
                            cx = f[0];
                            cy = f[1];
                        }
                    }
                    if (!((double)(dist = (dx = (float)((double)cx - x)) * dx + (dy = (float)((double)cy - y)) * dy) < minDistance)) continue;
                    minDistance = dist;
                    closest = e;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }

    private Shape getTransformedEdgeShape(Layout<V, E> layout, E e) {
        Pair<V> pair = layout.getGraph().getEndpoints(e);
        V v1 = pair.getFirst();
        V v2 = pair.getSecond();
        boolean isLoop = v1.equals(v2);
        Point2D p1 = this.vv.getRenderContext().getMultiLayerTransformer().transform(Layer.LAYOUT, (Point2D)layout.apply(v1));
        Point2D p2 = this.vv.getRenderContext().getMultiLayerTransformer().transform(Layer.LAYOUT, (Point2D)layout.apply(v2));
        if (p1 == null || p2 == null) {
            return null;
        }
        float x1 = (float)p1.getX();
        float y1 = (float)p1.getY();
        float x2 = (float)p2.getX();
        float y2 = (float)p2.getY();
        AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
        Shape edgeShape = (Shape)this.vv.getRenderContext().getEdgeShapeTransformer().apply(e);
        if (isLoop) {
            Shape s2 = (Shape)this.vv.getRenderContext().getVertexShapeTransformer().apply(v2);
            Rectangle2D s2Bounds = s2.getBounds2D();
            xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
            xform.translate(0.0, -edgeShape.getBounds2D().getHeight() / 2.0);
        } else {
            float dx = x2 - x1;
            float dy = y2 - y1;
            double theta = Math.atan2(dy, dx);
            xform.rotate(theta);
            float dist = (float)Math.sqrt(dx * dx + dy * dy);
            xform.scale(dist, 1.0);
        }
        edgeShape = xform.createTransformedShape(edgeShape);
        return edgeShape;
    }

    protected Collection<V> getFilteredVertices(Layout<V, E> layout) {
        if (this.verticesAreFiltered()) {
            Collection unfiltered = layout.getGraph().getVertices();
            LinkedHashSet filtered = new LinkedHashSet();
            for (Object v : unfiltered) {
                if (!this.isVertexRendered(Context.getInstance(layout.getGraph(), v))) continue;
                filtered.add(v);
            }
            return filtered;
        }
        return layout.getGraph().getVertices();
    }

    protected Collection<E> getFilteredEdges(Layout<V, E> layout) {
        if (this.edgesAreFiltered()) {
            Collection unfiltered = layout.getGraph().getEdges();
            LinkedHashSet filtered = new LinkedHashSet();
            for (Object e : unfiltered) {
                if (!this.isEdgeRendered(Context.getInstance(layout.getGraph(), e))) continue;
                filtered.add(e);
            }
            return filtered;
        }
        return layout.getGraph().getEdges();
    }

    protected boolean verticesAreFiltered() {
        Predicate<Context<Graph<V, E>, V>> vertexIncludePredicate = this.vv.getRenderContext().getVertexIncludePredicate();
        return vertexIncludePredicate != null && !vertexIncludePredicate.equals((Object)Predicates.alwaysTrue());
    }

    protected boolean edgesAreFiltered() {
        Predicate<Context<Graph<V, E>, E>> edgeIncludePredicate = this.vv.getRenderContext().getEdgeIncludePredicate();
        return edgeIncludePredicate != null && !edgeIncludePredicate.equals((Object)Predicates.alwaysTrue());
    }

    protected boolean isVertexRendered(Context<Graph<V, E>, V> context) {
        Predicate<Context<Graph<V, E>, V>> vertexIncludePredicate = this.vv.getRenderContext().getVertexIncludePredicate();
        return vertexIncludePredicate == null || vertexIncludePredicate.apply(context);
    }

    protected boolean isEdgeRendered(Context<Graph<V, E>, E> context) {
        Predicate<Context<Graph<V, E>, V>> vertexIncludePredicate = this.vv.getRenderContext().getVertexIncludePredicate();
        Predicate<Context<Graph<V, E>, E>> edgeIncludePredicate = this.vv.getRenderContext().getEdgeIncludePredicate();
        Graph g = (Graph)context.graph;
        Object e = context.element;
        boolean edgeTest = edgeIncludePredicate == null || edgeIncludePredicate.apply(context);
        Pair endpoints = g.getEndpoints(e);
        Object v1 = endpoints.getFirst();
        Object v2 = endpoints.getSecond();
        boolean endpointsTest = vertexIncludePredicate == null || vertexIncludePredicate.apply(Context.getInstance(g, v1)) && vertexIncludePredicate.apply(Context.getInstance(g, v2));
        return edgeTest && endpointsTest;
    }

    public float getPickSize() {
        return this.pickSize;
    }

    public void setPickSize(float pickSize) {
        this.pickSize = pickSize;
    }

    public static enum Style {
        LOWEST,
        CENTERED,
        HIGHEST;

    }
}

