/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.criteria;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliasBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AliasBuilder.class);
    final Map<String, Alias> m_aliases = new HashMap<String, Alias>();

    public final AliasBuilder alias(String associationPath, String alias, Alias.JoinType type, Restriction joinCondition) {
        Alias existing = this.m_aliases.get(alias);
        if (existing == null) {
            if (joinCondition == null) {
                this.m_aliases.put(alias, new Alias(associationPath, alias, type));
            } else {
                this.m_aliases.put(alias, new Alias(associationPath, alias, type, joinCondition));
            }
        } else if (joinCondition == null) {
            LOG.debug("alias '{}' already associated with associationPath '{}', skipping.", (Object)alias, (Object)associationPath);
        } else if (existing.hasJoinCondition()) {
            LOG.debug("alias '{}' already associated with associationPath '{}', appending join condition.", (Object)alias, (Object)associationPath);
            existing.setJoinCondition(Restrictions.and(existing.getJoinCondition(), joinCondition));
        } else {
            LOG.debug("alias '{}' already associated with associationPath '{}', adding join condition.", (Object)alias, (Object)associationPath);
            existing.setJoinCondition(joinCondition);
        }
        return this;
    }

    public final AliasBuilder alias(Alias alias) {
        Alias existing = this.m_aliases.get(alias.getAlias());
        if (existing == null) {
            this.m_aliases.put(alias.getAlias(), alias);
        } else if (alias.hasJoinCondition()) {
            if (existing.hasJoinCondition()) {
                LOG.debug("alias '{}' already associated with associationPath '{}', appending join condition.", (Object)alias.getAlias(), (Object)alias.getAssociationPath());
                existing.setJoinCondition(Restrictions.and(existing.getJoinCondition(), alias.getJoinCondition()));
            } else {
                LOG.debug("alias '{}' already associated with associationPath '{}', adding join condition.", (Object)alias.getAlias(), (Object)alias.getAssociationPath());
                existing.setJoinCondition(alias.getJoinCondition());
            }
        } else {
            LOG.debug("alias '{}' already associated with associationPath '{}', skipping.", (Object)alias.getAlias(), (Object)alias.getAssociationPath());
        }
        return this;
    }

    public final Collection<Alias> getAliasCollection() {
        return new ArrayList<Alias>(this.m_aliases.values());
    }
}

