/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.common;

import com.google.common.base.Strings;

public class SinkStrategy {
    public static final String IPC_STRATEGY = "org.opennms.core.ipc.strategy";
    public static final String SINK_STRATEGY_PROPERTY = "org.opennms.core.ipc.sink.strategy";
    private static final String CAMEL_SINK_STRATEGY_NAME = "camel";
    private static final String KAFKA_SINK_STRATEGY_NAME = "kafka";
    private static final String GRPC_SINK_STRATEGY_NAME = "grpc";
    private static final String OSGI_SINK_STRATEGY_NAME = "osgi";

    public static Strategy getSinkStrategy() {
        String effectiveStrategyName = System.getProperty(IPC_STRATEGY);
        if (Strings.isNullOrEmpty((String)effectiveStrategyName)) {
            effectiveStrategyName = System.getProperty(SINK_STRATEGY_PROPERTY, CAMEL_SINK_STRATEGY_NAME);
        }
        for (Strategy strategy : Strategy.values()) {
            if (!strategy.getName().equalsIgnoreCase(effectiveStrategyName)) continue;
            return strategy;
        }
        throw new IllegalArgumentException("Unsupported Sink strategy: " + effectiveStrategyName);
    }

    public static enum Strategy {
        CAMEL("camel", "JMS implementation using Camel"),
        KAFKA("kafka", "Kafka implementation using the Kafka consumer/producer APIs"),
        GRPC("grpc", "GRPC implementation using gRPC APIs"),
        OSGI("osgi", "OSGI Delegate implementation");

        private final String m_name;
        private final String m_descr;

        private Strategy(String name, String descr) {
            this.m_name = name;
            this.m_descr = descr;
        }

        private Strategy(String name) {
            this(name, name);
        }

        public String getName() {
            return this.m_name;
        }

        public String getDescr() {
            return this.m_descr;
        }
    }
}

