/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.config;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.poller.Monitor;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Service;

public class PollerConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = 2622622848304715121L;
    protected String redirectSuccess;
    Map<String, Service> pollerServices = new HashMap<String, Service>();
    Package pkg = null;
    PollerConfig pollerFactory = null;

    public void init() throws ServletException {
        this.reloadFiles();
    }

    public void reloadFiles() throws ServletException {
        ServletConfig config = this.getServletConfig();
        try {
            PollerConfigFactory.init();
            this.pollerFactory = PollerConfigFactory.getInstance();
            if (this.pollerFactory.getLocalConfiguration() == null) {
                throw new ServletException("Poller Configuration file is empty");
            }
        }
        catch (Throwable e) {
            throw new ServletException(e.getMessage());
        }
        this.initPollerServices();
        this.redirectSuccess = config.getInitParameter("redirect.success");
        if (this.redirectSuccess == null) {
            throw new ServletException("Missing required init parameter: redirect.success");
        }
    }

    public void initPollerServices() {
        Iterator pkgiter;
        List packageColl = this.pollerFactory.getExtendedConfiguration().getPackages();
        if (packageColl != null && (pkgiter = packageColl.iterator()).hasNext()) {
            this.pkg = (Package)pkgiter.next();
            List svcColl = this.pkg.getServices();
            for (Service svcProp : svcColl) {
                this.pollerServices.put(svcProp.getName(), svcProp);
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.reloadFiles();
        String query = request.getQueryString();
        if (query != null) {
            ArrayList<String> checkedList = new ArrayList<String>();
            ArrayList<String> deleteList = new ArrayList<String>();
            StringTokenizer strTok = new StringTokenizer(query, "&");
            while (strTok.hasMoreTokens()) {
                String token = strTok.nextToken();
                if (token == null) continue;
                StringTokenizer keyTokens = new StringTokenizer(token, "=");
                String name = null;
                if (keyTokens.hasMoreTokens()) {
                    name = keyTokens.nextToken();
                }
                if (!keyTokens.hasMoreTokens()) continue;
                String checked = keyTokens.nextToken();
                if (name == null) continue;
                if (name.indexOf("delete") == -1) {
                    this.modifyPollerInfo(checked, name);
                    checkedList.add(name);
                    continue;
                }
                String deleteService = name.substring(0, name.indexOf("delete"));
                deleteList.add(deleteService);
            }
            this.adjustNonChecked(checkedList);
            this.deleteThese(deleteList);
            try (OutputStreamWriter poller_fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONFIG_FILE_NAME)), StandardCharsets.UTF_8);){
                JaxbUtils.marshal((Object)this.pollerFactory.getLocalConfiguration(), (Writer)poller_fileWriter);
            }
        }
        response.sendRedirect(this.redirectSuccess);
    }

    public void adjustNonChecked(List<String> checkedList) {
        List svcColl;
        if (this.pkg != null && (svcColl = this.pkg.getServices()) != null) {
            for (Service svc : svcColl) {
                if (svc == null || checkedList.contains(svc.getName()) || !svc.getStatus().equals("on")) continue;
                svc.setStatus("off");
            }
        }
    }

    public void deleteThese(List<String> deleteServices) throws IOException {
        block0: for (String svcname : deleteServices) {
            List svcColl;
            if (this.pkg == null || (svcColl = this.pkg.getServices()) == null) continue;
            for (Service svc : svcColl) {
                if (svc == null || !svc.getName().equals(svcname)) continue;
                this.pkg.removeService(svc);
                this.removeMonitor(svc.getName());
                continue block0;
            }
        }
    }

    public void removeMonitor(String service) {
        List monitorColl = this.pollerFactory.getLocalConfiguration().getMonitors();
        if (monitorColl != null) {
            for (Monitor mon : monitorColl) {
                if (mon == null || !mon.getService().equals(service)) continue;
                this.pollerFactory.getLocalConfiguration().removeMonitor(mon);
                break;
            }
        }
    }

    public void modifyPollerInfo(String bPolled, String protocol) {
        List svcColl;
        if (this.pkg != null && (svcColl = this.pkg.getServices()) != null) {
            for (Service svc : svcColl) {
                if (svc == null || !svc.getName().equals(protocol)) continue;
                svc.setStatus(bPolled);
                break;
            }
        }
    }
}

