/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jmx.connection;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.jmx.connection.JmxConnectionConfig;

public class JmxConnectionConfigBuilder {
    private JmxConnectionConfig config = new JmxConnectionConfig();

    public static JmxConnectionConfigBuilder buildFrom(String ipAddress, Map<String, String> properties) {
        InetAddress inetAddress = InetAddressUtils.getInetAddress((String)ipAddress);
        return JmxConnectionConfigBuilder.buildFrom(inetAddress, properties);
    }

    public static JmxConnectionConfigBuilder buildFrom(InetAddress ipAddress, Map<String, String> properties) {
        JmxConnectionConfigBuilder builder = new JmxConnectionConfigBuilder();
        builder.withIpAddress(ipAddress);
        builder.withSunCacao(ParameterMap.getKeyedBoolean(properties, (String)"sunCacao", (boolean)false));
        builder.withUsername(properties.get("username"));
        builder.withPassword(properties.get("password"));
        builder.withFactory(properties.getOrDefault("factory", "STANDARD"));
        if (properties.get("url") == null) {
            String url = JmxConnectionConfigBuilder.createLegacyUrl(ipAddress, properties);
            builder.withUrl(url);
            builder.withPort(properties.getOrDefault("port", "1099"));
        } else {
            builder.withUrl(properties.get("url"));
        }
        return builder;
    }

    private static String createLegacyUrl(InetAddress ipAddress, Map<String, String> properties) {
        String ipAddrString = InetAddressUtils.toUrlIpAddress((InetAddress)ipAddress);
        String port = properties.getOrDefault("port", "1099");
        String protocol = properties.getOrDefault("protocol", "rmi");
        String urlPath = properties.getOrDefault("urlPath", "/jmxrmi");
        String rmiServerPort = properties.getOrDefault("rmiServerport", "45444");
        boolean remote = ParameterMap.getKeyedBoolean(properties, (String)"remoteJMX", (boolean)false);
        if (remote) {
            String url = String.format("service:jmx:%s:%s:%s://jndi/%s://%s:%s%s", protocol, ipAddrString, rmiServerPort, protocol, ipAddrString, port, urlPath);
            return url;
        }
        String url = String.format("service:jmx:%s:///jndi/%s://%s:%s%s", protocol, protocol, ipAddrString, port, urlPath);
        return url;
    }

    public JmxConnectionConfigBuilder withIpAddress(InetAddress ipAddress) {
        this.config.setIpAddress(ipAddress);
        return this;
    }

    public JmxConnectionConfigBuilder withPassword(String password) {
        this.config.setPassword(password);
        return this;
    }

    public JmxConnectionConfigBuilder withUsername(String username) {
        this.config.setUsername(username);
        return this;
    }

    private JmxConnectionConfigBuilder withSunCacao(boolean sunCacao) {
        this.config.setSunCacao(sunCacao);
        return this;
    }

    public JmxConnectionConfigBuilder withUrl(String url) {
        this.config.setUrl(url);
        return this;
    }

    public JmxConnectionConfigBuilder withFactory(String factory) {
        this.config.setFactory(factory);
        return this;
    }

    private JmxConnectionConfigBuilder withPort(String port) {
        this.config.setPort(port);
        return this;
    }

    public JmxConnectionConfig build() {
        return this.config;
    }
}

