/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.ClassBasedStrategyResolver;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.ColumnTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStrategy;
import org.opennms.netmgt.snmp.SnmpTrapBuilder;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;
import org.opennms.netmgt.snmp.SnmpV2TrapBuilder;
import org.opennms.netmgt.snmp.SnmpV3TrapBuilder;
import org.opennms.netmgt.snmp.SnmpV3User;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpValueFactory;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.snmp.StrategyResolver;
import org.opennms.netmgt.snmp.TrapNotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SnmpUtils {
    private static final transient Logger LOG = LoggerFactory.getLogger(SnmpUtils.class);
    private static final ClassBasedStrategyResolver s_classBasedStrategyResolver = new ClassBasedStrategyResolver();
    public static final String APPLIANCE_SNMP_COMMUNITY_ALIAS = "appliance.snmp";
    public static final String SNMP_COMMUNITY_ATTRIBUTE = "community";
    private static Properties sm_config;
    private static StrategyResolver s_strategyResolver;
    private static final boolean canUseClassBasedStrategy;
    static final byte[] HEX_CHAR_TABLE;

    public static SnmpWalker createWalker(SnmpAgentConfig agentConfig, String name, CollectionTracker ... trackers) {
        return SnmpUtils.getStrategy().createWalker(agentConfig, name, SnmpUtils.createTooBigTracker(agentConfig, trackers));
    }

    private static TooBigReportingAggregator createTooBigTracker(SnmpAgentConfig agentConfig, CollectionTracker ... trackers) {
        return new TooBigReportingAggregator(trackers, agentConfig.getAddress());
    }

    public static SnmpWalker createWalker(SnmpAgentConfig agentConfig, String name, CollectionTracker tracker) {
        return SnmpUtils.getStrategy().createWalker(agentConfig, name, SnmpUtils.createTooBigTracker(agentConfig, tracker));
    }

    private static TooBigReportingAggregator createTooBigTracker(SnmpAgentConfig agentConfig, CollectionTracker tracker) {
        return SnmpUtils.createTooBigTracker(agentConfig, new CollectionTracker[]{tracker});
    }

    public static SnmpValue get(SnmpAgentConfig agentConfig, SnmpObjId oid) {
        return SnmpUtils.getStrategy().get(agentConfig, oid);
    }

    public static SnmpValue[] get(SnmpAgentConfig agentConfig, SnmpObjId[] oids) {
        return SnmpUtils.getStrategy().get(agentConfig, oids);
    }

    public static CompletableFuture<SnmpValue[]> getAsync(SnmpAgentConfig agentConfig, SnmpObjId[] oids) {
        return SnmpUtils.getStrategy().getAsync(agentConfig, oids);
    }

    public static CompletableFuture<SnmpValue[]> setAsync(SnmpAgentConfig agentConfig, SnmpObjId[] oids, SnmpValue[] values) {
        return SnmpUtils.getStrategy().setAsync(agentConfig, oids, values);
    }

    public static SnmpValue getNext(SnmpAgentConfig agentConfig, SnmpObjId oid) {
        return SnmpUtils.getStrategy().getNext(agentConfig, oid);
    }

    public static SnmpValue[] getNext(SnmpAgentConfig agentConfig, SnmpObjId[] oids) {
        return SnmpUtils.getStrategy().getNext(agentConfig, oids);
    }

    public static SnmpValue[] getBulk(SnmpAgentConfig agentConfig, SnmpObjId[] oids) {
        return SnmpUtils.getStrategy().getBulk(agentConfig, oids);
    }

    public static SnmpValue set(SnmpAgentConfig agentConfig, SnmpObjId oid, SnmpValue value) {
        return SnmpUtils.getStrategy().set(agentConfig, oid, value);
    }

    public static SnmpValue[] set(SnmpAgentConfig agentConfig, SnmpObjId[] oids, SnmpValue[] values) {
        return SnmpUtils.getStrategy().set(agentConfig, oids, values);
    }

    public static Properties getConfig() {
        return sm_config == null ? System.getProperties() : sm_config;
    }

    public static List<SnmpValue> getColumns(SnmpAgentConfig agentConfig, String name, SnmpObjId oid) throws InterruptedException {
        final ArrayList<SnmpValue> results = new ArrayList<SnmpValue>();
        try (SnmpWalker walker = SnmpUtils.createWalker(agentConfig, name, (CollectionTracker)new ColumnTracker(oid){

            @Override
            protected void storeResult(SnmpResult res) {
                results.add(res.getValue());
            }
        });){
            walker.start();
            walker.waitFor();
        }
        return results;
    }

    public static Map<SnmpInstId, SnmpValue> getOidValues(SnmpAgentConfig agentConfig, String name, SnmpObjId oid) throws InterruptedException {
        final LinkedHashMap<SnmpInstId, SnmpValue> results = new LinkedHashMap<SnmpInstId, SnmpValue>();
        try (SnmpWalker walker = SnmpUtils.createWalker(agentConfig, name, (CollectionTracker)new ColumnTracker(oid){

            @Override
            protected void storeResult(SnmpResult res) {
                results.put(res.getInstance(), res.getValue());
            }
        });){
            walker.start();
            walker.waitFor();
        }
        return results;
    }

    public static void setConfig(Properties config) {
        sm_config = config;
    }

    public static SnmpStrategy getStrategy() {
        if (SnmpUtils.isClassBasedStrategyInstantiable()) {
            return s_classBasedStrategyResolver.getStrategy();
        }
        return SnmpUtils.getStrategyResolver().getStrategy();
    }

    private static boolean checkIfClassBasedStrategyIsInstantiable() {
        try {
            s_classBasedStrategyResolver.getStrategy();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isClassBasedStrategyInstantiable() {
        return canUseClassBasedStrategy;
    }

    public static StrategyResolver getStrategyResolver() {
        return s_strategyResolver != null ? s_strategyResolver : s_classBasedStrategyResolver;
    }

    public static void setStrategyResolver(StrategyResolver strategyResolver) {
        if (!SnmpUtils.isClassBasedStrategyInstantiable()) {
            s_strategyResolver = strategyResolver;
        }
    }

    public static void unsetStrategyResolver() {
        s_strategyResolver = null;
    }

    public static String getStrategyClassName() {
        return SnmpUtils.getConfig().getProperty("org.opennms.snmp.strategyClass", "org.opennms.netmgt.snmp.snmp4j.Snmp4JStrategy");
    }

    public static void registerForTraps(TrapNotificationListener listener, InetAddress address, int snmpTrapPort, List<SnmpV3User> snmpUsers) throws IOException {
        SnmpUtils.getStrategy().registerForTraps(listener, address, snmpTrapPort, snmpUsers);
    }

    public static void registerForTraps(TrapNotificationListener listener, InetAddress address, int snmpTrapPort) throws IOException {
        SnmpUtils.getStrategy().registerForTraps(listener, address, snmpTrapPort);
    }

    public static void unregisterForTraps(TrapNotificationListener listener) throws IOException {
        SnmpUtils.getStrategy().unregisterForTraps(listener);
    }

    public static SnmpValueFactory getValueFactory() {
        return SnmpUtils.getStrategy().getValueFactory();
    }

    public static SnmpV1TrapBuilder getV1TrapBuilder() {
        return SnmpUtils.getStrategy().getV1TrapBuilder();
    }

    public static SnmpTrapBuilder getV2TrapBuilder() {
        return SnmpUtils.getStrategy().getV2TrapBuilder();
    }

    public static SnmpV3TrapBuilder getV3TrapBuilder() {
        return SnmpUtils.getStrategy().getV3TrapBuilder();
    }

    public static SnmpV2TrapBuilder getV2InformBuilder() {
        return SnmpUtils.getStrategy().getV2InformBuilder();
    }

    public static SnmpV3TrapBuilder getV3InformBuilder() {
        return SnmpUtils.getStrategy().getV3InformBuilder();
    }

    public static String getLocalEngineID() {
        return SnmpUtils.getHexString(SnmpUtils.getStrategy().getLocalEngineID());
    }

    public static String getHexString(byte[] raw) {
        byte[] hex = new byte[2 * raw.length];
        int index = 0;
        for (byte b : raw) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        try {
            return new String(hex, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Failed to get hex string", (Throwable)e);
            return null;
        }
    }

    public static Long getProtoCounter63Value(SnmpValue value) {
        Long retval = SnmpUtils.getProtoCounter63Value(value.getBytes());
        if (retval != null && value.isDisplayable()) {
            LOG.info("Value '{}' is entirely displayable but still meets our other checks to be treated as a proto-Counter64. This may not be what you want.", (Object)new String(value.getBytes()));
        }
        return retval;
    }

    public static Long getProtoCounter63Value(byte[] valBytes) {
        if (valBytes.length != 8) {
            LOG.trace("Value should be 8 bytes long for a proto-Counter63 but this one is {} bytes.", (Object)valBytes);
            return null;
        }
        if (Arrays.equals(valBytes, new byte[]{-128, 0, 0, 0, 0, 0, 0, 0})) {
            LOG.trace("Value has high-order bit set and all others zero, which indicates \"not supported\" in FCMGMT-MIB convention");
            return null;
        }
        if ((valBytes[0] & 0x80) == 128) {
            LOG.trace("Value has high-order bit set but proto-Counter63 should only be 63 bits");
            return null;
        }
        boolean onlyNumeric = true;
        for (byte digit : valBytes) {
            if (digit >= 48 && digit <= 57) continue;
            onlyNumeric = false;
            break;
        }
        if (onlyNumeric) {
            LOG.trace("Value contains only ASCII decimal numbers so it should be interpreted as a decimal counter");
            return null;
        }
        Long retVal = Long.decode(String.format("0x%02x%02x%02x%02x%02x%02x%02x%02x", valBytes[0], valBytes[1], valBytes[2], valBytes[3], valBytes[4], valBytes[5], valBytes[6], valBytes[7]));
        LOG.trace("Converted octet-string {} as a proto-Counter63 of value {}", (Object)String.format("0x%02x%02x%02x%02x%02x%02x%02x%02x", valBytes[0], valBytes[1], valBytes[2], valBytes[3], valBytes[4], valBytes[5], valBytes[6], valBytes[7]), (Object)retVal);
        return retVal;
    }

    static {
        canUseClassBasedStrategy = SnmpUtils.checkIfClassBasedStrategyIsInstantiable();
        HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    }

    private static final class TooBigReportingAggregator
    extends AggregateTracker {
        private final InetAddress address;

        private TooBigReportingAggregator(CollectionTracker[] children, InetAddress address) {
            super(children);
            this.address = address;
        }

        @Override
        protected void reportTooBigErr(String msg) {
            LOG.info("Received tooBig response from {}. {}", (Object)this.address, (Object)msg);
        }
    }
}

