/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.kafka.producer.shell;

import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.kafka.producer.datasync.AlarmDataStore;
import org.opennms.features.kafka.producer.model.OpennmsModelProtos;
import org.opennms.features.kafka.producer.shell.SyncAlarms;

@Command(scope="opennms", name="kafka-list-alarms", description="Enumerates the alarms that are currently in the Kafka data store.")
@Service
public class ListAlarms
implements Action {
    @Reference
    private AlarmDataStore alarmDataStore;
    @Option(name="-k", aliases={"--reduction-key"}, description="Lookup the alarm at a specific reduction key.")
    private String reductionKey;

    public Object execute() {
        if (!SyncAlarms.waitForAlarmDataStore(this.alarmDataStore, 15L, TimeUnit.SECONDS)) {
            return null;
        }
        LinkedHashMap<String, OpennmsModelProtos.Alarm> alarmsByReductionKey = new LinkedHashMap<String, OpennmsModelProtos.Alarm>();
        if (this.reductionKey != null) {
            alarmsByReductionKey.put(this.reductionKey, this.alarmDataStore.getAlarm(this.reductionKey));
        } else {
            alarmsByReductionKey.putAll(this.alarmDataStore.getAlarms());
        }
        alarmsByReductionKey.forEach(this::printAlarm);
        return null;
    }

    private void printAlarm(String reductionKey, OpennmsModelProtos.Alarm alarm) {
        System.out.printf("%s\n\t%s\n", reductionKey, alarm != null ? alarm.getLastEvent().getLabel() : "(No alarm)");
    }
}

