/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.rest.impl.converter.json;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opennms.netmgt.graph.api.Edge;
import org.opennms.netmgt.graph.api.ImmutableGraph;
import org.opennms.netmgt.graph.api.Vertex;
import org.opennms.netmgt.graph.api.focus.Focus;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.rest.api.Converter;
import org.opennms.netmgt.graph.rest.impl.converter.JsonPropertyConverterService;
import org.opennms.netmgt.graph.rest.impl.converter.json.VertexConverter;
import org.osgi.framework.BundleContext;

public class GraphConverter
implements Converter<ImmutableGraph<?, ?>, JSONObject> {
    private final BundleContext bundleContext;

    public GraphConverter(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    public boolean canConvert(Class<ImmutableGraph<?, ?>> type) {
        return ImmutableGraph.class.isAssignableFrom(type);
    }

    public JSONObject convert(ImmutableGraph<?, ?> input) {
        JSONObject jsonGraph = new JSONObject();
        JSONArray jsonEdgesArray = new JSONArray();
        JSONArray jsonVerticesArray = new JSONArray();
        jsonGraph.put("edges", (Object)jsonEdgesArray);
        jsonGraph.put("vertices", (Object)jsonVerticesArray);
        if (input != null) {
            JsonPropertyConverterService propertyConverterService = new JsonPropertyConverterService(this.bundleContext);
            Map properties = input.asGenericGraph().getProperties();
            JSONObject convertedProperties = propertyConverterService.convert(properties);
            convertedProperties.toMap().forEach((arg_0, arg_1) -> ((JSONObject)jsonGraph).put(arg_0, arg_1));
            input.getEdges().stream().sorted(Comparator.comparing(Edge::getId)).forEach(edge -> {
                GenericEdge genericEdge = edge.asGenericEdge();
                HashMap<String, Object> edgeProperties = new HashMap<String, Object>(genericEdge.getProperties());
                edgeProperties.put("source", genericEdge.getSource());
                edgeProperties.put("target", genericEdge.getTarget());
                JSONObject jsonEdge = propertyConverterService.convert(edgeProperties);
                jsonEdgesArray.put((Object)jsonEdge);
            });
            input.getVertices().stream().sorted(Comparator.comparing(Vertex::getId)).forEach(vertex -> {
                JSONObject jsonVertex = new VertexConverter(this.bundleContext).convert((Vertex)vertex);
                jsonVerticesArray.put((Object)jsonVertex);
            });
            Focus defaultFocus = input.getDefaultFocus();
            JSONObject jsonFocus = new JSONObject();
            jsonFocus.put("type", (Object)defaultFocus.getId());
            jsonFocus.put("vertexIds", (Object)new JSONArray((Collection)defaultFocus.getVertexRefs()));
            jsonGraph.put("defaultFocus", (Object)jsonFocus);
        }
        return jsonGraph;
    }
}

