/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.shell;

import java.io.PrintStream;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.netmgt.timeseries.TimeseriesStorageManager;
import org.opennms.netmgt.timeseries.stats.StatisticsCollector;

@Command(scope="opennms", name="ts-stats", description="Prints statistics about the timeseries integration layer.")
@Service
public class TimeseriesStatsCommand
implements Action {
    @Reference
    private TimeseriesStorageManager storageManager;
    @Reference
    private StatisticsCollector stats;

    public Object execute() throws Exception {
        PrintStream out = System.out;
        out.println("Active TimeSeriesStorage plugin:");
        out.println(this.storageManager.get().getClass().getName());
        out.println();
        out.println("Metrics with highest number of tags:");
        this.stats.getTopNMetricsWithMostTags().stream().map(this::toString).forEach(out::println);
        out.println();
        out.println("Tags with highest number of unique values (top 100):");
        this.stats.getTopNTags().stream().limit(100L).forEach(out::println);
        return null;
    }

    private String toString(Metric metric) {
        return metric.getFirstTagByKey("resourceId").getValue() + "/" + metric.getFirstTagByKey("name").getValue() + "\n    metaTags:      " + metric.getMetaTags().toString() + "\n    externalTags: " + metric.getExternalTags().toString();
    }
}

