/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.model.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.mapstruct.factory.Mappers;
import org.opennms.features.apilayer.model.mappers.IpInterfaceMapper;
import org.opennms.features.apilayer.model.mappers.MetaDataMapper;
import org.opennms.features.apilayer.model.mappers.MonitoredServiceMapper;
import org.opennms.features.apilayer.model.mappers.SnmpInterfaceMapper;
import org.opennms.integration.api.v1.model.MetaData;
import org.opennms.integration.api.v1.model.MonitoredService;
import org.opennms.integration.api.v1.model.SnmpInterface;
import org.opennms.integration.api.v1.model.immutables.ImmutableIpInterface;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMetaData;
import org.opennms.netmgt.model.OnmsMonitoredService;

public class IpInterfaceMapperImpl
implements IpInterfaceMapper {
    private final MetaDataMapper metaDataMapper = (MetaDataMapper)Mappers.getMapper(MetaDataMapper.class);
    private final SnmpInterfaceMapper snmpInterfaceMapper = (SnmpInterfaceMapper)Mappers.getMapper(SnmpInterfaceMapper.class);
    private final MonitoredServiceMapper monitoredServiceMapper = (MonitoredServiceMapper)Mappers.getMapper(MonitoredServiceMapper.class);

    @Override
    public ImmutableIpInterface map(OnmsIpInterface onmsIpInterface) {
        if (onmsIpInterface == null) {
            return null;
        }
        ImmutableIpInterface.Builder immutableIpInterface = ImmutableIpInterface.newBuilder();
        immutableIpInterface.setIpAddress(onmsIpInterface.getIpAddress());
        immutableIpInterface.setSnmpInterface((SnmpInterface)this.snmpInterfaceMapper.map(onmsIpInterface.getSnmpInterface()));
        immutableIpInterface.setMetaData(this.onmsMetaDataListToMetaDataList(onmsIpInterface.getMetaData()));
        immutableIpInterface.setMonitoredServices(this.onmsMonitoredServiceSetToMonitoredServiceList(onmsIpInterface.getMonitoredServices()));
        return immutableIpInterface.build();
    }

    protected List<MetaData> onmsMetaDataListToMetaDataList(List<OnmsMetaData> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MetaData> list1 = new ArrayList<MetaData>(list.size());
        for (OnmsMetaData onmsMetaData : list) {
            list1.add((MetaData)this.metaDataMapper.map(onmsMetaData));
        }
        return list1;
    }

    protected List<MonitoredService> onmsMonitoredServiceSetToMonitoredServiceList(Set<OnmsMonitoredService> set) {
        if (set == null) {
            return null;
        }
        ArrayList<MonitoredService> list = new ArrayList<MonitoredService>(set.size());
        for (OnmsMonitoredService onmsMonitoredService : set) {
            list.add((MonitoredService)this.monitoredServiceMapper.map(onmsMonitoredService));
        }
        return list;
    }
}

