/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.graphml.status;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.opennms.features.topology.plugins.topo.graphml.status.GraphMLStatus;
import org.opennms.netmgt.model.OnmsSeverity;

public class GraphMLEdgeStatus
extends GraphMLStatus {
    private GraphMLEdgeStatus(OnmsSeverity severity, Map<String, String> styleProperties) {
        super(severity, styleProperties);
    }

    public GraphMLEdgeStatus() {
        super(OnmsSeverity.NORMAL);
    }

    @Override
    public Set<String> getAllowedStyleProperties() {
        return ImmutableSet.of((Object)"stroke", (Object)"stroke-width", (Object)"stroke-opacity", (Object)"stroke-dasharray");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GraphMLEdgeStatus)) {
            return false;
        }
        GraphMLEdgeStatus that = (GraphMLEdgeStatus)o;
        return Objects.equal((Object)this.getSeverity(), (Object)that.getSeverity()) && Objects.equal(this.getStyleProperties(), that.getStyleProperties());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getSeverity(), this.getStyleProperties()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("severity", (Object)this.getSeverity()).add("styleProperties", this.getStyleProperties()).toString();
    }

    public static GraphMLEdgeStatus merge(GraphMLEdgeStatus s1, GraphMLEdgeStatus s2) {
        return new GraphMLEdgeStatus(GraphMLStatus.mergeSeverity(s1, s2), GraphMLStatus.mergeStyleProperties(s1, s2));
    }
}

