/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.commands;

import com.google.common.base.Throwables;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionHandlerFilter;
import org.opennms.features.jmxconfiggenerator.commands.CmdRunException;
import org.opennms.features.jmxconfiggenerator.log.ConsoleLogAdapter;

public abstract class Command {
    protected final ConsoleLogAdapter LOG = new ConsoleLogAdapter();
    @Option(name="-h", usage="Show help", aliases={"--help"})
    private boolean help = false;
    @Option(name="-v", usage="Verbose mode", aliases={"--verbose"})
    private boolean debugFlag = false;
    private CmdLineParser parser;

    protected boolean isHelp() {
        return this.help;
    }

    public void run(CmdLineParser parser) throws CmdRunException, CmdLineException {
        this.LOG.setDebug(this.debugFlag);
        this.LOG.debug("Running in verbose mode", new Object[0]);
        this.printFieldValues();
        this.parser = parser;
        if (this.isHelp()) {
            this.printUsage();
        } else {
            this.validate(this.getParser());
            this.execute();
        }
    }

    private void printFieldValues() {
        if (!this.LOG.isDebugEnabled()) {
            return;
        }
        this.LOG.debug("Options/Arguments set for {}", this.getClass().getName());
        Class<?> currentClass = this.getClass();
        do {
            this.printFieldValues(currentClass);
        } while ((currentClass = currentClass.getSuperclass()) != Object.class);
    }

    private void printFieldValues(Class<?> clazz) {
        try {
            for (Field eachField : clazz.getDeclaredFields()) {
                eachField.setAccessible(true);
                if (eachField.getAnnotation(Option.class) != null) {
                    Option option = eachField.getAnnotation(Option.class);
                    this.LOG.debug("%tOption {} = {}", option.name(), eachField.get(this));
                }
                if (eachField.getAnnotation(Argument.class) == null) continue;
                this.LOG.debug("%tArgument {}", eachField.get(this));
            }
        }
        catch (IllegalAccessException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    protected abstract void execute() throws CmdRunException, CmdLineException;

    protected abstract void validate(CmdLineParser var1) throws CmdLineException;

    public void printUsage() {
        CmdLineParser parser = new CmdLineParser((Object)this);
        this.LOG.info(this.getDescription(), new Object[0]);
        this.LOG.info("", new Object[0]);
        parser.printUsage((Writer)new OutputStreamWriter(this.LOG.getOutputStream()), null, OptionHandlerFilter.ALL);
    }

    protected CmdLineParser getParser() {
        return this.parser;
    }

    protected abstract String getDescription();
}

