/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.dialogs;

import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.vaadin.dialogs.ConfirmDialog;

public class DefaultConfirmDialogFactory
implements ConfirmDialog.Factory {
    private static final long serialVersionUID = -5412321247707480466L;
    protected static final String DEFAULT_CAPTION = "Confirm";
    protected static final String DEFAULT_MESSAGE = "Are You sure?";
    protected static final String DEFAULT_OK_CAPTION = "Ok";
    protected static final String DEFAULT_CANCEL_CAPTION = "Cancel";
    private static final double MIN_WIDTH = 20.0;
    private static final double MAX_WIDTH = 40.0;
    private static final double MIN_HEIGHT = 1.0;
    private static final double MAX_HEIGHT = 30.0;
    private static final double BUTTON_HEIGHT = 2.5;

    @Override
    public ConfirmDialog create(String caption, String message, String okCaption, String cancelCaption, String notOkCaption) {
        boolean threeWay = notOkCaption != null;
        final ConfirmDialog confirm = new ConfirmDialog();
        confirm.setCloseShortcut(27, new int[0]);
        confirm.setId("confirmdialog-window");
        confirm.setCaption(caption != null ? caption : DEFAULT_CAPTION);
        confirm.addCloseListener(new Window.CloseListener(){
            private static final long serialVersionUID = 1971800928047045825L;

            public void windowClose(Window.CloseEvent ce) {
                if (confirm.isEnabled()) {
                    confirm.setEnabled(false);
                    confirm.setConfirmed(false);
                    if (confirm.getListener() != null) {
                        confirm.getListener().onClose(confirm);
                    }
                }
            }
        });
        VerticalLayout c = new VerticalLayout();
        confirm.setContent((Component)c);
        c.setSizeFull();
        c.setSpacing(true);
        c.setMargin(true);
        VerticalLayout scrollContent = new VerticalLayout();
        scrollContent.setMargin(false);
        Panel panel = new Panel((Component)scrollContent);
        c.addComponent((Component)panel);
        panel.setWidth("100%");
        panel.setHeight("100%");
        panel.setStyleName("borderless");
        panel.addStyleName("borderless");
        c.setExpandRatio((Component)panel, 1.0f);
        Label text = new Label("", ContentMode.HTML);
        text.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        text.setId("confirmdialog-message");
        scrollContent.addComponent((Component)text);
        confirm.setMessageLabel(text);
        confirm.setMessage(message);
        HorizontalLayout buttons = new HorizontalLayout();
        c.addComponent((Component)buttons);
        c.setComponentAlignment((Component)buttons, Alignment.TOP_RIGHT);
        buttons.setSpacing(true);
        final Button cancel = this.buildCancelButton(cancelCaption);
        confirm.setCancelButton(cancel);
        Button notOk = null;
        if (threeWay) {
            notOk = this.buildNotOkButton(notOkCaption);
            confirm.setNotOkButton(notOk);
        }
        final Button ok = this.buildOkButton(okCaption);
        confirm.setOkButton(ok);
        Button.ClickListener cb = new Button.ClickListener(){
            private static final long serialVersionUID = 3525060915814334881L;

            public void buttonClick(Button.ClickEvent event) {
                if (confirm.isEnabled()) {
                    confirm.setEnabled(false);
                    Button b = event.getButton();
                    if (b != cancel) {
                        confirm.setConfirmed(b == ok);
                    }
                    UI parent = confirm.getUI();
                    parent.removeWindow((Window)confirm);
                    if (confirm.getListener() != null) {
                        confirm.getListener().onClose(confirm);
                    }
                }
            }
        };
        cancel.addClickListener(cb);
        ok.addClickListener(cb);
        if (notOk != null) {
            notOk.addClickListener(cb);
        }
        for (Button button : this.orderButtons(cancel, notOk, ok)) {
            if (button == null) continue;
            buttons.addComponent((Component)button);
        }
        double[] dim = this.getDialogDimensions(message, ConfirmDialog.ContentMode.TEXT_WITH_NEWLINES);
        confirm.setWidth(this.format(dim[0]) + "em");
        confirm.setHeight(this.format(dim[1]) + "em");
        confirm.setResizable(false);
        return confirm;
    }

    protected List<Button> orderButtons(Button cancel, Button notOk, Button ok) {
        return Arrays.asList(cancel, notOk, ok);
    }

    protected Button buildCancelButton(String cancelCaption) {
        Button cancel = new Button(cancelCaption != null ? cancelCaption : DEFAULT_CANCEL_CAPTION);
        cancel.setData(null);
        cancel.setId("confirmdialog-cancel-button");
        return cancel;
    }

    protected Button buildNotOkButton(String notOkCaption) {
        Button notOk = new Button(notOkCaption);
        notOk.setData((Object)false);
        notOk.setId("confirmdialog-not-ok-button");
        return notOk;
    }

    protected Button buildOkButton(String okCaption) {
        Button ok = new Button(okCaption != null ? okCaption : DEFAULT_OK_CAPTION);
        ok.setData((Object)true);
        ok.setId("confirmdialog-ok-button");
        ok.setClickShortcut(13, new int[0]);
        ok.setStyleName("primary");
        ok.focus();
        return ok;
    }

    protected double[] getDialogDimensions(String message, ConfirmDialog.ContentMode style) {
        double chrW = 0.51;
        double chrH = 1.5;
        double length = message != null ? chrW * (double)message.length() : 0.0;
        double rows = Math.ceil(length / 40.0);
        if (style == ConfirmDialog.ContentMode.TEXT_WITH_NEWLINES) {
            rows += message != null ? (double)DefaultConfirmDialogFactory.count("\n", message) : 0.0;
        }
        double width = Math.min(40.0, length);
        double height = Math.ceil(Math.min(30.0, rows * chrH));
        width = Math.max(width, 20.0);
        height = Math.max(height, 1.0);
        double btnHeight = 4.0;
        double vmargin = 5.0;
        double hmargin = 1.0;
        double[] res = new double[]{width + hmargin, height + btnHeight + vmargin};
        return res;
    }

    private static int count(String needle, String haystack) {
        int count = 0;
        int pos = -1;
        while ((pos = haystack.indexOf(needle, pos + 1)) >= 0) {
            ++count;
        }
        return count;
    }

    private String format(double n) {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setMaximumFractionDigits(1);
        nf.setGroupingUsed(false);
        return nf.format(n);
    }
}

