/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.validation;

import java.util.Objects;
import org.opennms.netmgt.flows.classification.error.Errors;
import org.opennms.netmgt.flows.classification.exception.ClassificationException;
import org.opennms.netmgt.flows.classification.persistence.api.ClassificationRuleDao;
import org.opennms.netmgt.flows.classification.persistence.api.Group;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;

public class GroupValidator {
    private final ClassificationRuleDao ruleDao;

    public GroupValidator(ClassificationRuleDao ruleDao) {
        this.ruleDao = Objects.requireNonNull(ruleDao);
    }

    public void validate(Group group, Rule potentialNewRule) {
        if (potentialNewRule != null) {
            Objects.requireNonNull(group);
            Rule existingRule = this.ruleDao.findByDefinition(potentialNewRule, group);
            if (existingRule != null) {
                throw new ClassificationException("name", Errors.GROUP_DUPLICATE_RULE, new Object[0]);
            }
        }
    }
}

