/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.application;

import org.opennms.features.topology.api.topo.AbstractLevelAwareVertex;
import org.opennms.features.topology.api.topo.LevelAware;
import org.opennms.netmgt.graph.api.NodeRef;
import org.opennms.netmgt.graph.provider.application.ApplicationVertex;
import org.opennms.netmgt.graph.provider.application.ApplicationVertexType;
import org.opennms.netmgt.model.OnmsApplication;

public class LegacyApplicationVertex
extends AbstractLevelAwareVertex
implements LevelAware {
    private Integer serviceTypeId;

    public LegacyApplicationVertex(ApplicationVertex vertex) {
        this(vertex.getId(), vertex.getName());
        boolean isApplication;
        boolean bl = isApplication = vertex.getVertexType() == ApplicationVertexType.Application;
        if (isApplication) {
            this.setTooltipText(String.format("Application '%s'", vertex.getName()));
            this.setIconKey("application.application");
        } else {
            this.setTooltipText(String.format("Service '%s', IP: %s", vertex.getName(), vertex.getIpAddress()));
            this.setIpAddress(vertex.getIpAddress());
            this.setServiceTypeId(vertex.getServiceTypeId());
            this.setIconKey("application.monitored-service");
            NodeRef nodeRef = vertex.getNodeRef();
            if (nodeRef != null && nodeRef.getNodeId() != null) {
                this.setNodeID(nodeRef.getNodeId());
            }
        }
    }

    public LegacyApplicationVertex(OnmsApplication application) {
        this(application.getId().toString(), application.getName());
        this.setTooltipText(String.format("Application '%s'", application.getName()));
        this.setIconKey("application.application");
    }

    public LegacyApplicationVertex(String id, String label) {
        super("application", id, label);
    }

    public void setServiceTypeId(Integer serviceTypeId) {
        this.serviceTypeId = serviceTypeId;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    public Integer getServiceTypeId() {
        return this.serviceTypeId;
    }

    public boolean isPartOf(String applicationId) {
        return applicationId != null && applicationId.equals(this.getRoot().getId());
    }

    public LegacyApplicationVertex getRoot() {
        if (this.isRoot()) {
            return this;
        }
        return ((LegacyApplicationVertex)this.getParent()).getRoot();
    }

    public int getLevel() {
        return this.isRoot() ? 0 : 1;
    }
}

