/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.MeetMeRoom;
import org.asteriskjava.live.MeetMeUser;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.live.internal.MeetMeUserImpl;
import org.asteriskjava.manager.action.CommandAction;

class MeetMeRoomImpl
extends AbstractLiveObject
implements MeetMeRoom {
    private static final String COMMAND_PREFIX = "meetme";
    private static final String LOCK_COMMAND = "lock";
    private static final String UNLOCK_COMMAND = "unlock";
    private final String roomNumber;
    private final Map<Integer, MeetMeUserImpl> users;

    MeetMeRoomImpl(AsteriskServerImpl server, String roomNumber) {
        super(server);
        this.roomNumber = roomNumber;
        this.users = new HashMap<Integer, MeetMeUserImpl>(20);
    }

    @Override
    public String getRoomNumber() {
        return this.roomNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<MeetMeUser> getUsers() {
        Map<Integer, MeetMeUserImpl> map = this.users;
        synchronized (map) {
            return new ArrayList<MeetMeUser>(this.users.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Map<Integer, MeetMeUserImpl> map = this.users;
        synchronized (map) {
            return this.users.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<MeetMeUserImpl> getUserImpls() {
        Map<Integer, MeetMeUserImpl> map = this.users;
        synchronized (map) {
            return new ArrayList<MeetMeUserImpl>(this.users.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUser(MeetMeUserImpl user) {
        Map<Integer, MeetMeUserImpl> map = this.users;
        synchronized (map) {
            this.users.put(user.getUserNumber(), user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MeetMeUserImpl getUser(Integer userNumber) {
        Map<Integer, MeetMeUserImpl> map = this.users;
        synchronized (map) {
            return this.users.get(userNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUser(MeetMeUserImpl user) {
        Map<Integer, MeetMeUserImpl> map = this.users;
        synchronized (map) {
            this.users.remove(user.getUserNumber());
        }
    }

    @Override
    public void lock() throws ManagerCommunicationException {
        this.sendMeetMeCommand(LOCK_COMMAND);
    }

    @Override
    public void unlock() throws ManagerCommunicationException {
        this.sendMeetMeCommand(UNLOCK_COMMAND);
    }

    private void sendMeetMeCommand(String command) throws ManagerCommunicationException {
        StringBuffer sb = new StringBuffer();
        sb.append(COMMAND_PREFIX);
        sb.append(" ");
        sb.append(command);
        sb.append(" ");
        sb.append(this.roomNumber);
        this.server.sendAction(new CommandAction(sb.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int systemHashcode;
        StringBuffer sb = new StringBuffer("MeetMeRoom[");
        MeetMeRoomImpl meetMeRoomImpl = this;
        synchronized (meetMeRoomImpl) {
            sb.append("roomNumber='").append(this.getRoomNumber()).append("',");
            systemHashcode = System.identityHashCode(this);
        }
        sb.append("systemHashcode=").append(systemHashcode);
        sb.append("]");
        return sb.toString();
    }
}

