/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;

public class XMLMarshalException
extends ValidationException {
    public static final int INVALID_XPATH_STRING = 25001;
    public static final int INVALID_XPATH_INDEX_STRING = 25002;
    public static final int MARSHAL_EXCEPTION = 25003;
    public static final int UNMARSHAL_EXCEPTION = 25004;
    public static final int VALIDATE_EXCEPTION = 25005;
    public static final int DEFAULT_ROOT_ELEMENT_NOT_SPECIFIED = 25006;
    public static final int DESCRIPTOR_NOT_FOUND_IN_PROJECT = 25007;
    public static final int NO_DESCRIPTOR_WITH_MATCHING_ROOT_ELEMENT = 25008;
    public static final int SCHEMA_REFERENCE_NOT_SET = 25010;
    public static final int NULL_ARGUMENT = 25011;
    public static final int ERROR_RESOLVING_XML_SCHEMA = 25012;
    public static final int ERROR_SETTING_SCHEMAS = 25013;
    public static final int ERROR_INSTANTIATING_SCHEMA_PLATFORM = 25014;
    public static final int NAMESPACE_RESOLVER_NOT_SPECIFIED = 25015;
    public static final int NAMESPACE_NOT_FOUND = 25016;
    public static final int ENUM_CLASS_NOT_SPECIFIED = 25017;
    public static final int FROMSTRING_METHOD_ERROR = 25018;
    public static final int INVALID_ENUM_CLASS_SPECIFIED = 25019;
    public static final int ILLEGAL_STATE_XML_UNMARSHALLER_HANDLER = 25020;
    public static final int INVALID_SWA_REF_ATTRIBUTE_TYPE = 25021;
    public static final int NO_ENCODER_FOR_MIME_TYPE = 25022;
    public static final int NO_DESCRIPTOR_FOUND = 25023;
    public static final int ERROR_INSTANTIATING_UNMAPPED_CONTENTHANDLER = 25024;
    public static final int UNMAPPED_CONTENTHANDLER_DOESNT_IMPLEMENT = 25025;
    public static final int OBJ_NOT_FOUND_IN_CACHE = 25026;
    public static final int NO_ATTACHMENT_UNMARSHALLER_SET = 25027;
    public static final int UNKNOWN_XSI_TYPE = 25028;
    public static final int SUBCLASS_ATTEMPTED_TO_OVERRIDE_NAMESPACE_DECLARATION = 25029;
    public static final int ERROR_INVOKING_NAMESPACE_PREFIX_MAPPER = 25030;
    public static final int ERROR_PROCESSING_PREFIX_MAPPER = 25031;
    public static final int ERROR_INVOKING_CHARACTER_ESCAPE_HANDLER = 25032;
    public static final int ERROR_PROCESSING_CHARACTER_ESCAPE_HANDLER = 25033;
    public static final int ERROR_INVOKING_ID_RESOLVER = 25034;
    public static final int ERROR_PROCESSING_ID_RESOLVER = 25035;
    public static final int WRAPPED_ID_RESOLVER_WITH_MULTI_ID = 25036;
    public static final int OBJECT_CYCLE_DETECTED = 25037;
    public static final int PLATFORM_NOT_SUPPORTED_WITH_JSON_MEDIA_TYPE = 25038;
    public static final int UNMARSHAL_FROM_STRING_FAILED = 25039;
    public static final int MISSING_ID_FOR_IDREF = 25040;
    public static final int INVALID_ATTRIBUTE_GROUP_NAME = 25041;
    public static final int NULL_VALUE_NOT_ALLOWED_FOR_VARIABLE = 25042;

    protected XMLMarshalException(String message) {
        super(message);
    }

    protected XMLMarshalException(String message, Exception internalException) {
        super(message, internalException);
    }

    public static XMLMarshalException invalidXPathString(String xpathString, Exception nestedException) {
        Object[] args = new Object[]{xpathString};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25001, args), nestedException);
        exception.setErrorCode(25001);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLMarshalException invalidXPathIndexString(String xpathString) {
        Object[] args = new Object[]{xpathString};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25002, args));
        exception.setErrorCode(25002);
        return exception;
    }

    public static XMLMarshalException marshalException(Exception nestedException) {
        Object[] args = new Object[]{};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25003, args), nestedException);
        exception.setErrorCode(25003);
        return exception;
    }

    public static XMLMarshalException unmarshalException() {
        Object[] args = new Object[]{};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25004, args));
        exception.setErrorCode(25004);
        return exception;
    }

    public static XMLMarshalException unmarshalException(Exception nestedException) {
        Object[] args = new Object[]{};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25004, args), nestedException);
        exception.setErrorCode(25004);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLMarshalException validateException(Exception nestedException) {
        Object[] args = new Object[]{};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25005, args), nestedException);
        exception.setErrorCode(25005);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLMarshalException defaultRootElementNotSpecified(XMLDescriptor descriptor) {
        Object[] args = new Object[]{descriptor.getJavaClassName()};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25006, args));
        exception.setErrorCode(25006);
        return exception;
    }

    public static XMLMarshalException descriptorNotFoundInProject(String className) {
        Object[] args = new Object[]{className};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25007, args));
        exception.setErrorCode(25007);
        return exception;
    }

    public static XMLMarshalException noDescriptorWithMatchingRootElement(String rootElementName) {
        Object[] args = new Object[]{rootElementName};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25008, args));
        exception.setErrorCode(25008);
        return exception;
    }

    public static XMLMarshalException schemaReferenceNotSet(XMLDescriptor descriptor) {
        Object[] args = new Object[]{descriptor.getJavaClassName()};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25010, args));
        exception.setErrorCode(25010);
        return exception;
    }

    public static XMLMarshalException nullArgumentException() {
        Object[] args = new Object[]{};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25011, args));
        exception.setErrorCode(25011);
        return exception;
    }

    public static XMLMarshalException errorResolvingXMLSchema(Exception nestedException) {
        Object[] args = new Object[]{};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25012, args), nestedException);
        exception.setErrorCode(25012);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLMarshalException errorSettingSchemas(Exception nestedException, Object[] schemas) {
        Object[] args = new Object[]{};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25012, args), nestedException);
        exception.setErrorCode(25013);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLMarshalException errorInstantiatingSchemaPlatform(Exception nestedException) {
        Object[] args = new Object[]{};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25014, args), nestedException);
        exception.setErrorCode(25014);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLMarshalException namespaceResolverNotSpecified(String localName) {
        Object[] args = new Object[]{localName};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25015, args));
        exception.setErrorCode(25015);
        return exception;
    }

    public static XMLMarshalException namespaceNotFound(String prefix) {
        Object[] args = new Object[]{prefix};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25016, args));
        exception.setErrorCode(25016);
        return exception;
    }

    public static XMLMarshalException enumClassNotSpecified() {
        Object[] args = new Object[]{};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25017, args));
        exception.setErrorCode(25017);
        return exception;
    }

    public static XMLMarshalException errorInvokingFromStringMethod(Exception nestedException, String className) {
        Object[] args = new Object[]{className};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25018, args), nestedException);
        exception.setErrorCode(25018);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLMarshalException invalidEnumClassSpecified(Exception nestedException, String className) {
        Object[] args = new Object[]{className};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25019, args), nestedException);
        exception.setErrorCode(25019);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLMarshalException illegalStateXMLUnmarshallerHandler() {
        Object[] args = new Object[]{};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25020, args));
        exception.setErrorCode(25020);
        return exception;
    }

    public static XMLMarshalException invalidSwaRefAttribute(String attributeClassification) {
        Object[] args = new Object[]{attributeClassification};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25021, args));
        exception.setErrorCode(25021);
        return exception;
    }

    public static XMLMarshalException noEncoderForMimeType(String mimeType) {
        Object[] args = new Object[]{mimeType};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25022, args));
        exception.setErrorCode(25022);
        return exception;
    }

    public static XMLMarshalException noDescriptorFound(Mapping mapping) {
        Object[] args = new Object[]{mapping.getAttributeName()};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25023, args));
        exception.setErrorCode(25023);
        return exception;
    }

    public static XMLMarshalException noDescriptorFound(DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping.getAttributeName()};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25023, args));
        exception.setErrorCode(25023);
        return exception;
    }

    public static XMLMarshalException errorInstantiatingUnmappedContentHandler(Exception nestedException, String className) {
        Object[] args = new Object[]{className};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25024, args), nestedException);
        exception.setErrorCode(25024);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLMarshalException unmappedContentHandlerDoesntImplement(Exception nestedException, String className) {
        Object[] args = new Object[]{className};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25025, args), nestedException);
        exception.setErrorCode(25025);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLMarshalException objectNotFoundInCache(String nodeName) {
        Object[] args = new Object[]{nodeName};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25026, args));
        exception.setErrorCode(25026);
        return exception;
    }

    public static XMLMarshalException noAttachmentUnmarshallerSet(String cid) {
        Object[] args = new Object[]{cid};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25027, args));
        exception.setErrorCode(25027);
        return exception;
    }

    public static XMLMarshalException unknownXsiTypeValue(String xsiType, Mapping mapping) {
        Object[] args = new Object[]{xsiType, mapping};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25028, args));
        exception.setErrorCode(25028);
        return exception;
    }

    public static XMLMarshalException unknownXsiTypeValue(String xsiType, DatabaseMapping mapping) {
        Object[] args = new Object[]{xsiType, mapping};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25028, args));
        exception.setErrorCode(25028);
        return exception;
    }

    public static XMLMarshalException subclassAttemptedToOverrideNamespaceDeclaration(String prefix, String subClassName, String subClassNamespaceURI, String parentClassName, String parentClassNamespaceURI) {
        Object[] args = new Object[]{prefix, subClassName, subClassNamespaceURI, parentClassName, parentClassNamespaceURI};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25029, args));
        exception.setErrorCode(25029);
        return exception;
    }

    public static XMLMarshalException errorInvokingPrefixMapperMethod(String methodName, Object prefixMapper) {
        Object[] args = new Object[]{methodName, prefixMapper};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25030, args));
        exception.setErrorCode(25030);
        return exception;
    }

    public static XMLMarshalException errorProcessingPrefixMapper(String methodName, Object prefixMapper) {
        Object[] args = new Object[]{methodName, prefixMapper};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25031, args));
        exception.setErrorCode(25031);
        return exception;
    }

    public static XMLMarshalException errorInvokingCharacterEscapeHandler(String methodName, Object handler, Throwable nestedException) {
        Object[] args = new Object[]{methodName, handler};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25032, args));
        exception.setErrorCode(25032);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLMarshalException errorProcessingCharacterEscapeHandler(String methodName, Object handler, Throwable nestedException) {
        Object[] args = new Object[]{methodName, handler};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25033, args));
        exception.setErrorCode(25033);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLMarshalException errorInvokingIDResolver(String methodName, Object resolver, Throwable nestedException) {
        Object[] args = new Object[]{methodName, resolver};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25034, args));
        exception.setErrorCode(25034);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLMarshalException errorProcessingIDResolver(String methodName, Object resolver, Throwable nestedException) {
        Object[] args = new Object[]{methodName, resolver};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25035, args));
        exception.setErrorCode(25035);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLMarshalException wrappedIDResolverWithMultiID(String keyString, Object resolver) {
        Object[] args = new Object[]{keyString, resolver};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25036, args));
        exception.setErrorCode(25036);
        return exception;
    }

    public static XMLMarshalException objectCycleDetected(String objectCycleString) {
        Object[] args = new Object[]{objectCycleString};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25037, args));
        exception.setErrorCode(25037);
        return exception;
    }

    public static XMLMarshalException unsupportedMediaTypeForPlatform() {
        Object[] args = new Object[]{};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25038, args));
        exception.setErrorCode(25038);
        return exception;
    }

    public static XMLMarshalException unmarshalFromStringException(String systemId, Exception nestedException) {
        Object[] args = new Object[]{systemId};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25039, args));
        exception.setInternalException(nestedException);
        exception.setErrorCode(25038);
        return exception;
    }

    public static XMLMarshalException missingIDForIDRef(String classname, Object[] primaryKey) {
        String id = "";
        int i = 0;
        while (i < primaryKey.length) {
            id = String.valueOf(id) + primaryKey[i];
            if (i < primaryKey.length - 1) {
                id = String.valueOf(id) + ", ";
            }
            ++i;
        }
        Object[] args = new Object[]{classname, id};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25040, args));
        exception.setErrorCode(25040);
        return exception;
    }

    public static XMLMarshalException invalidAttributeGroupName(String groupName, String className) {
        Object[] args = new Object[]{groupName, className};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25041, args));
        exception.setErrorCode(25041);
        return exception;
    }

    public static XMLMarshalException nullValueNotAllowed(String variableName, String className) {
        Object[] args = new Object[]{variableName, className};
        XMLMarshalException exception = new XMLMarshalException(ExceptionMessageGenerator.buildMessage(XMLMarshalException.class, 25042, args));
        exception.setErrorCode(25042);
        return exception;
    }
}

