/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.service.impl;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.deviceconfig.service.DeviceConfigService;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.poller.DeviceConfig;
import org.opennms.netmgt.poller.LocationAwarePollerClient;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollerResponse;
import org.opennms.netmgt.poller.ServiceMonitorAdaptor;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.opennms.netmgt.poller.support.SimpleMonitoredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DeviceConfigServiceImpl
implements DeviceConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceConfigServiceImpl.class);
    private static final String DEVICE_CONFIG_SERVICE_CLASS_NAME = "org.opennms.features.deviceconfig.monitors.DeviceConfigMonitor";
    @Autowired
    private LocationAwarePollerClient locationAwarePollerClient;
    @Autowired
    private SessionUtils sessionUtils;
    @Autowired
    private IpInterfaceDao ipInterfaceDao;
    @Qualifier(value="deviceConfigMonitorAdaptor")
    private ServiceMonitorAdaptor serviceMonitorAdaptor;
    @Autowired
    private PollerConfig pollerConfig;

    public CompletableFuture<DeviceConfigService.DeviceConfigBackupResponse> triggerConfigBackup(String ipAddress, String location, String service, boolean persist) throws IOException {
        try {
            InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException e) {
            LOG.error("Unknown/Invalid IpAddress {}", (Object)ipAddress);
            throw new IllegalArgumentException("Unknown/Invalid IpAddress " + ipAddress);
        }
        return ((CompletableFuture)this.pollDeviceConfig(ipAddress, location, service, persist).thenApply(response -> new DeviceConfigService.DeviceConfigBackupResponse(response.getPollStatus().getReason(), response.getPollStatus().getDeviceConfig().getScriptOutput()))).whenComplete((response, throwable) -> {
            if (throwable != null) {
                LOG.error("Error while getting device config for IpAddress {} at location {}", new Object[]{ipAddress, location, throwable});
            }
        });
    }

    public CompletableFuture<DeviceConfig> getDeviceConfig(String ipAddress, String location, String service, boolean persist, int timeout) throws IOException {
        return ((CompletableFuture)this.pollDeviceConfig(ipAddress, location, service, persist).orTimeout(timeout, TimeUnit.MILLISECONDS).thenApply(resp -> {
            if (resp.getPollStatus().isAvailable()) {
                return resp.getPollStatus().getDeviceConfig();
            }
            throw new RuntimeException("Requesting backup failed: " + resp.getPollStatus().getReason());
        })).whenComplete((config, throwable) -> {
            if (throwable != null) {
                LOG.error("Error while getting device config for IpAddress {} at location {}", new Object[]{ipAddress, location, throwable});
            }
        });
    }

    public List<DeviceConfigService.RetrievalDefinition> getRetrievalDefinitions(String ipAddress, String location) {
        OnmsIpInterface iface = this.findMatchingInterface(ipAddress, location, null);
        if (iface == null) {
            return Collections.emptyList();
        }
        return iface.getMonitoredServices().stream().flatMap(svc -> this.pollerConfig.findService(InetAddressUtils.str((InetAddress)svc.getIpAddress()), svc.getServiceName()).stream()).filter(match -> this.pollerConfig.getServiceMonitorLocator(match.service.getName()).map(loc -> Objects.equals(loc.getServiceLocatorKey(), DEVICE_CONFIG_SERVICE_CLASS_NAME)).orElse(false)).map(match -> {
            final String serviceName = match.serviceName;
            final Map pollerParameters = this.locationAwarePollerClient.poll().withService((MonitoredService)new SimpleMonitoredService(InetAddressUtils.addr((String)ipAddress), iface.getNode().getId().intValue(), iface.getNode().getLabel(), match.serviceName, location)).withAttributes(match.service.getParameterMap()).withPatternVariables(match.patternVariables).getInterpolatedAttributes();
            return new DeviceConfigService.RetrievalDefinition(){

                public String getServiceName() {
                    return serviceName;
                }

                public String getConfigType() {
                    return AbstractServiceMonitor.getKeyedString((Map)pollerParameters, (String)"config-type", (String)"default");
                }

                public String getSchedule() {
                    return AbstractServiceMonitor.getKeyedString((Map)pollerParameters, (String)"schedule", (String)"0 0 0 * * ?");
                }
            };
        }).collect(Collectors.toList());
    }

    private CompletableFuture<PollerResponse> pollDeviceConfig(String ipAddress, String location, String serviceName, boolean persist) throws IOException {
        Package.ServiceMatch match = (Package.ServiceMatch)this.getPollerConfig().findService(ipAddress, serviceName).orElseThrow(IllegalArgumentException::new);
        ServiceMonitorLocator monitor = (ServiceMonitorLocator)this.getPollerConfig().getServiceMonitorLocator(match.service.getName()).orElseThrow(IllegalArgumentException::new);
        AbstractMap.SimpleImmutableEntry boundServicePair = (AbstractMap.SimpleImmutableEntry)this.sessionUtils.withReadOnlyTransaction(() -> {
            OnmsIpInterface ipInterface = this.findMatchingInterface(ipAddress, location, serviceName);
            if (ipInterface == null) {
                return null;
            }
            boolean bound = ipInterface.getMonitoredServices().stream().map(OnmsMonitoredService::getServiceName).anyMatch(s -> serviceName.equals(s));
            OnmsNode node = ipInterface.getNode();
            return new AbstractMap.SimpleImmutableEntry<Boolean, SimpleMonitoredService>(bound, new SimpleMonitoredService(ipInterface.getIpAddress(), node.getId().intValue(), node.getLabel(), match.serviceName, location));
        });
        if (boundServicePair == null) {
            throw new IllegalArgumentException("No interface found with ipAddress " + ipAddress + " at location " + location);
        }
        Boolean serviceBound = (Boolean)boundServicePair.getKey();
        MonitoredService service = (MonitoredService)boundServicePair.getValue();
        if (!serviceBound.booleanValue()) {
            throw new IllegalArgumentException("Service " + serviceName + " not bound to interface with ipAddress " + ipAddress + " at location " + location);
        }
        if (persist) {
            return this.locationAwarePollerClient.poll().withService(service).withAdaptor(this.serviceMonitorAdaptor).withMonitorLocator(monitor).withPatternVariables(match.patternVariables).withAttributes(match.service.getParameterMap()).withAttribute("dcbTriggeredPoll", (Object)"true").execute();
        }
        return this.locationAwarePollerClient.poll().withService(service).withMonitorLocator(monitor).withPatternVariables(match.patternVariables).withAttributes(match.service.getParameterMap()).withAttribute("dcbTriggeredPoll", (Object)"true").execute();
    }

    private OnmsIpInterface findMatchingInterface(String ipAddress, String location, String serviceName) {
        OnmsIpInterface iface;
        List ipInterfaces = this.ipInterfaceDao.findByIpAddressAndLocation(ipAddress, location);
        OnmsIpInterface onmsIpInterface = iface = ipInterfaces.size() > 0 ? (OnmsIpInterface)ipInterfaces.get(0) : null;
        if (ipInterfaces.size() > 1) {
            Optional<OnmsIpInterface> optionalInterface = ipInterfaces.stream().filter(ipInterface -> ipInterface.getMonitoredServices().stream().anyMatch(monitoredService -> {
                if (Strings.isNullOrEmpty((String)serviceName)) {
                    return monitoredService.getServiceName().startsWith("DeviceConfig");
                }
                return monitoredService.getServiceName().equals(serviceName);
            })).findFirst();
            iface = optionalInterface.orElseGet(() -> ipInterfaces.stream().findFirst().orElse(null));
        }
        return iface;
    }

    public void setLocationAwarePollerClient(LocationAwarePollerClient locationAwarePollerClient) {
        this.locationAwarePollerClient = locationAwarePollerClient;
    }

    public void setSessionUtils(SessionUtils sessionUtils) {
        this.sessionUtils = sessionUtils;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.ipInterfaceDao = ipInterfaceDao;
    }

    public void setServiceMonitorAdaptor(ServiceMonitorAdaptor serviceMonitorAdaptor) {
        this.serviceMonitorAdaptor = serviceMonitorAdaptor;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.pollerConfig = pollerConfig;
    }

    public PollerConfig getPollerConfig() {
        return this.pollerConfig;
    }
}

