/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.coordinator.group.Utils;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;

public class OffsetAndMetadata {
    private static final String NO_METADATA = "";
    public final long offset;
    public final OptionalInt leaderEpoch;
    public final String metadata;
    public final long commitTimestampMs;
    public final OptionalLong expireTimestampMs;

    public OffsetAndMetadata(long offset, OptionalInt leaderEpoch, String metadata, long commitTimestampMs, OptionalLong expireTimestampMs) {
        this.offset = offset;
        this.leaderEpoch = Objects.requireNonNull(leaderEpoch);
        this.metadata = Objects.requireNonNull(metadata);
        this.commitTimestampMs = commitTimestampMs;
        this.expireTimestampMs = Objects.requireNonNull(expireTimestampMs);
    }

    public String toString() {
        return "OffsetAndMetadata(offset=" + this.offset + ", leaderEpoch=" + this.leaderEpoch + ", metadata=" + this.metadata + ", commitTimestampMs=" + this.commitTimestampMs + ", expireTimestampMs=" + this.expireTimestampMs + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetAndMetadata that = (OffsetAndMetadata)o;
        if (this.offset != that.offset) {
            return false;
        }
        if (this.commitTimestampMs != that.commitTimestampMs) {
            return false;
        }
        if (!this.leaderEpoch.equals(that.leaderEpoch)) {
            return false;
        }
        if (!this.metadata.equals(that.metadata)) {
            return false;
        }
        return this.expireTimestampMs.equals(that.expireTimestampMs);
    }

    public int hashCode() {
        int result = (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + this.leaderEpoch.hashCode();
        result = 31 * result + this.metadata.hashCode();
        result = 31 * result + (int)(this.commitTimestampMs ^ this.commitTimestampMs >>> 32);
        result = 31 * result + this.expireTimestampMs.hashCode();
        return result;
    }

    public static OffsetAndMetadata fromRecord(OffsetCommitValue record) {
        return new OffsetAndMetadata(record.offset(), Utils.ofSentinel(record.leaderEpoch()), record.metadata(), record.commitTimestamp(), Utils.ofSentinel(record.expireTimestamp()));
    }

    public static OffsetAndMetadata fromRequest(OffsetCommitRequestData.OffsetCommitRequestPartition partition, long currentTimeMs, OptionalLong expireTimestampMs) {
        return new OffsetAndMetadata(partition.committedOffset(), Utils.ofSentinel(partition.committedLeaderEpoch()), partition.committedMetadata() == null ? NO_METADATA : partition.committedMetadata(), partition.commitTimestamp() == -1L ? currentTimeMs : partition.commitTimestamp(), expireTimestampMs);
    }
}

