/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.api.search.GraphSearchService;
import org.opennms.netmgt.graph.api.search.SearchContext;
import org.opennms.netmgt.graph.api.search.SearchCriteria;
import org.opennms.netmgt.graph.api.search.SearchProvider;
import org.opennms.netmgt.graph.api.search.SearchSuggestion;
import org.opennms.netmgt.graph.api.service.GraphService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGraphSearchService
implements GraphSearchService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultGraphSearchService.class);
    private static final int MIN_CHAR_FOR_SEARCH = 3;
    private Map<String, SearchProvider> graphSearchProviders = new HashMap<String, SearchProvider>();
    private GraphService graphService;

    public DefaultGraphSearchService(GraphService graphService) {
        this.graphService = graphService;
    }

    public List<SearchSuggestion> getSuggestions(String namespace, String input) {
        Objects.requireNonNull(namespace);
        if (input == null || input.length() < 3) {
            return Collections.emptyList();
        }
        SearchContext context = SearchContext.builder().graphService(this.graphService).suggestionsLimit(10).build();
        TreeSet<SearchSuggestion> suggestions = new TreeSet<SearchSuggestion>(Comparator.comparing(SearchSuggestion::getLabel).thenComparing(SearchSuggestion::getContext));
        for (SearchProvider provider : this.graphSearchProviders.values()) {
            if (!provider.canSuggest(this.graphService, namespace)) continue;
            List suggestionsOfProvider = provider.getSuggestions(context, namespace, input);
            if (suggestionsOfProvider == null) {
                LOG.warn("Provider {} does not work properly, received null suggestion list.", (Object)provider.getProviderId());
                continue;
            }
            List excludeNullResults = suggestionsOfProvider.stream().filter(Objects::nonNull).collect(Collectors.toList());
            if (excludeNullResults.size() != suggestionsOfProvider.size()) {
                LOG.warn("Provider {} returned a null value. Please ensure it is implemented correctly", (Object)provider.getProviderId());
            }
            suggestions.addAll(excludeNullResults);
        }
        return new ArrayList<SearchSuggestion>(suggestions);
    }

    public List<GenericVertex> search(SearchCriteria searchCriteria) {
        SearchProvider provider = this.graphSearchProviders.get(searchCriteria.getProviderId());
        Objects.requireNonNull(provider, "Could not find provider with id=" + searchCriteria.getProviderId());
        Objects.requireNonNull(searchCriteria.getCriteria());
        return provider.resolve(this.graphService, searchCriteria);
    }

    public void onBind(SearchProvider graphSearchProvider, Map<String, String> props) {
        this.graphSearchProviders.put(graphSearchProvider.getProviderId(), graphSearchProvider);
    }

    public void onUnbind(SearchProvider graphSearchProvider, Map<String, String> props) {
        if (graphSearchProvider != null) {
            this.graphSearchProviders.remove(graphSearchProvider.getProviderId());
        }
    }
}

