/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.enrichment;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.graph.api.NodeService;
import org.opennms.netmgt.graph.api.enrichment.EnrichmentGraphBuilder;
import org.opennms.netmgt.graph.api.enrichment.EnrichmentProcessor;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.enrichment.EnrichmentUtils;

public class NodeEnrichmentProcessor
implements EnrichmentProcessor {
    private final NodeService nodeService;

    public NodeEnrichmentProcessor(NodeService nodeService) {
        this.nodeService = Objects.requireNonNull(nodeService);
    }

    public boolean canEnrich(GenericGraph graph) {
        return EnrichmentUtils.parseBoolean(graph.getProperties(), "enrichment.resolveNodes");
    }

    public void enrich(EnrichmentGraphBuilder graphBuilder) {
        List nodeRefs = graphBuilder.getVertices().stream().map(GenericVertex::getNodeRef).filter(Objects::nonNull).collect(Collectors.toList());
        List nodeInfos = this.nodeService.resolveNodes(nodeRefs);
        nodeInfos.forEach(ni -> {
            List vertices = graphBuilder.resolveVertices(ni.getNodeRef());
            for (GenericVertex eachVertex : vertices) {
                graphBuilder.property(eachVertex, "nodeInfo", ni);
            }
        });
    }
}

