/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.health.rest.internal;

import io.vavr.control.Either;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opennms.core.health.api.Context;
import org.opennms.core.health.api.Health;
import org.opennms.core.health.api.HealthCheck;
import org.opennms.core.health.api.HealthCheckService;
import org.opennms.core.health.api.Response;
import org.opennms.core.health.rest.HealthCheckRestService;
import org.opennms.core.health.rest.internal.UnhealthyStatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckRestServiceImpl
implements HealthCheckRestService {
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheckRestServiceImpl.class);
    private static final String SUCCESS_MESSAGE = "Everything is awesome";
    private static final String ERROR_MESSAGE = "Oh no, something is wrong";
    private final HealthCheckService healthCheckService;

    public HealthCheckRestServiceImpl(HealthCheckService healthCheckService) {
        this.healthCheckService = Objects.requireNonNull(healthCheckService);
    }

    @Override
    public javax.ws.rs.core.Response probeHealth(int timeoutInMs, int maxAgeMs, UriInfo uriInfo) {
        List tags = (List)uriInfo.getQueryParameters().get((Object)"tag");
        Boolean isSuccess = (Boolean)this.getHealthInternally(timeoutInMs, maxAgeMs, tags).fold(errorMessage -> false, health -> health.isSuccess());
        if (isSuccess.booleanValue()) {
            return javax.ws.rs.core.Response.ok().header("Health", (Object)SUCCESS_MESSAGE).entity((Object)SUCCESS_MESSAGE).build();
        }
        return javax.ws.rs.core.Response.status((Response.StatusType)new UnhealthyStatusType()).header("Health", (Object)ERROR_MESSAGE).entity((Object)ERROR_MESSAGE).build();
    }

    @Override
    public javax.ws.rs.core.Response getHealth(int timeoutInMs, int maxAgeMs, UriInfo uriInfo) {
        List tags = (List)uriInfo.getQueryParameters().get((Object)"tag");
        Pair flagAndResponse = (Pair)this.getHealthInternally(timeoutInMs, maxAgeMs, tags).fold(errorMessage -> {
            JSONObject jsonHealth = new JSONObject();
            JSONArray jsonResponseArray = new JSONArray();
            jsonHealth.put("healthy", false);
            jsonHealth.put("errorMessage", errorMessage);
            jsonHealth.put("responses", (Object)jsonResponseArray);
            return Pair.of((Object)false, (Object)jsonHealth);
        }, health -> {
            JSONObject jsonHealth = new JSONObject();
            JSONArray jsonResponseArray = new JSONArray();
            jsonHealth.put("healthy", health.isSuccess());
            jsonHealth.put("errorMessage", (Object)null);
            jsonHealth.put("responses", (Object)jsonResponseArray);
            for (Pair pair : health.getResponses()) {
                JSONObject eachJsonResponse = new JSONObject();
                eachJsonResponse.put("status", (Object)((Response)pair.getRight()).getStatus().name());
                eachJsonResponse.put("description", (Object)((HealthCheck)pair.getLeft()).getDescription());
                eachJsonResponse.put("message", (Object)((Response)pair.getRight()).getMessage());
                jsonResponseArray.put((Object)eachJsonResponse);
            }
            return Pair.of((Object)health.isSuccess(), (Object)jsonHealth);
        });
        LOG.debug("Rest response : {}", (Object)((JSONObject)flagAndResponse.getRight()).toString());
        return javax.ws.rs.core.Response.ok().header("Health", (Object)((Boolean)flagAndResponse.getLeft() != false ? SUCCESS_MESSAGE : ERROR_MESSAGE)).entity((Object)((JSONObject)flagAndResponse.getRight()).toString()).build();
    }

    private Either<String, Health> getHealthInternally(int timeoutInMs, int maxAgeMs, List<String> tags) {
        Context context = new Context();
        context.setTimeout((long)timeoutInMs);
        context.setMaxAge(Duration.ofMillis(maxAgeMs));
        return this.healthCheckService.performAsyncHealthCheck(context, null, tags).map(f -> {
            try {
                return (Health)f.toCompletableFuture().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

