/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.BmpParser;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.Header;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.Packet;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerAccessor;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerInfo;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.TLV;

public class TerminationPacket
implements Packet {
    public final Header header;
    public final TLV.List<Element, Element.Type, Information> information;

    public TerminationPacket(Header header, ByteBuf buffer, PeerAccessor peerAccessor) throws InvalidPacketException {
        this.header = Objects.requireNonNull(header);
        this.information = TLV.List.wrap(BufferUtils.repeatRemaining((ByteBuf)buffer, Element::new));
    }

    @Override
    public void accept(Packet.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <R> R map(Packet.Mapper<R> mapper) {
        return mapper.map(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("terminations", this.information).toString();
    }

    public static class UnknownInformation
    implements Information {
        @Override
        public void accept(Information.Visitor visitor) {
            visitor.visit(this);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }
    }

    public static class ReasonInformation
    implements Information {
        public final int reason;

        public ReasonInformation(int reason) {
            this.reason = reason;
        }

        @Override
        public void accept(Information.Visitor visitor) {
            visitor.visit(this);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("reason", this.reason).toString();
        }
    }

    public static class StringInformation
    implements Information {
        public final String string;

        public StringInformation(String string) {
            this.string = string;
        }

        @Override
        public void accept(Information.Visitor visitor) {
            visitor.visit(this);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("string", (Object)this.string).toString();
        }
    }

    public static interface Information {
        public void accept(Visitor var1);

        public static interface Visitor {
            public void visit(StringInformation var1);

            public void visit(ReasonInformation var1);

            public void visit(UnknownInformation var1);
        }
    }

    public static class Element
    extends TLV<Type, Information, Void> {
        public Element(ByteBuf buffer) throws InvalidPacketException {
            super(buffer, Type::from, null, Optional.empty());
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum Type implements TLV.Type<Information, Void>
        {
            STRING{

                @Override
                public Information parse(ByteBuf buffer, Void parameter, Optional<PeerInfo> peerInfo) {
                    return new StringInformation(new String(BufferUtils.bytes((ByteBuf)buffer, (int)buffer.readableBytes()), StandardCharsets.UTF_8));
                }
            }
            ,
            REASON{

                @Override
                public Information parse(ByteBuf buffer, Void parameter, Optional<PeerInfo> peerInfo) {
                    int reason = BufferUtils.uint16((ByteBuf)buffer);
                    return new ReasonInformation(reason);
                }
            }
            ,
            UNKNOWN{

                @Override
                public Information parse(ByteBuf buffer, Void parameter, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
                    return new UnknownInformation();
                }
            };


            private static Type from(int type) {
                switch (type) {
                    case 0: {
                        return STRING;
                    }
                    case 1: {
                        return REASON;
                    }
                }
                BmpParser.RATE_LIMITED_LOG.debug("Unknown Termination Packet Type: {}", (Object)type);
                return UNKNOWN;
            }
        }
    }
}

