/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.tasks;

import org.opennms.core.tasks.AbstractTask;
import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.TaskCoordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncTask
extends AbstractTask {
    private static final Logger LOG = LoggerFactory.getLogger(SyncTask.class);
    private final Runnable m_action;
    private String m_preferredExecutor = "default";

    public SyncTask(TaskCoordinator coordinator, ContainerTask<?> parent, Runnable action) {
        this(coordinator, parent, action, "default");
    }

    public SyncTask(TaskCoordinator coordinator, ContainerTask<?> parent, Runnable action, String preferredExecutor) {
        super(coordinator, parent);
        this.m_action = action;
        this.m_preferredExecutor = preferredExecutor;
    }

    @Override
    protected void doSubmit() {
        this.getCoordinator().submitToExecutor(this.getPreferredExecutor(), this.getRunnable(), this);
    }

    private final void run() {
        if (this.m_action != null) {
            this.m_action.run();
        }
    }

    final Runnable getRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    SyncTask.this.run();
                }
                catch (Throwable t) {
                    LOG.debug("Exception occurred executing task " + String.valueOf(SyncTask.this), t);
                }
            }

            public String toString() {
                return "Runner for " + String.valueOf(SyncTask.this);
            }
        };
    }

    public String getPreferredExecutor() {
        return this.m_preferredExecutor;
    }

    public void setPreferredExecutor(String preferredExecutor) {
        this.m_preferredExecutor = preferredExecutor;
    }

    @Override
    public String toString() {
        return this.m_action == null ? super.toString() : this.m_action.toString();
    }
}

