/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.tasks;

import org.opennms.core.tasks.AbstractTask;
import org.opennms.core.tasks.Async;
import org.opennms.core.tasks.Callback;
import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.TaskCoordinator;
import org.springframework.util.Assert;

public class AsyncTask<T>
extends AbstractTask {
    private final Async<T> m_async;
    private final Callback<T> m_callback;

    public AsyncTask(TaskCoordinator coordinator, ContainerTask<?> parent, Async<T> async) {
        this(coordinator, parent, async, null);
    }

    public AsyncTask(TaskCoordinator coordinator, ContainerTask<?> parent, Async<T> async, Callback<T> callback) {
        super(coordinator, parent);
        Assert.notNull(async, (String)"async parameter must not be null");
        this.m_async = async;
        this.m_callback = callback;
    }

    @Override
    public String toString() {
        return String.valueOf(this.m_async);
    }

    @Override
    protected void doSubmit() {
        Callback<T> callback = this.callback();
        try {
            this.m_async.supplyAsyncThenAccept(callback);
        }
        catch (Throwable t) {
            callback.handleException(t);
        }
    }

    private final void markTaskAsCompleted() {
        this.getCoordinator().markTaskAsCompleted(this);
    }

    private Callback<T> callback() {
        return new Callback<T>(){

            @Override
            public void accept(T t) {
                try {
                    if (AsyncTask.this.m_callback != null) {
                        AsyncTask.this.m_callback.accept(t);
                    }
                }
                finally {
                    AsyncTask.this.markTaskAsCompleted();
                }
            }

            @Override
            public T apply(Throwable t) {
                try {
                    if (AsyncTask.this.m_callback != null) {
                        AsyncTask.this.m_callback.handleException(t);
                    }
                }
                finally {
                    AsyncTask.this.markTaskAsCompleted();
                }
                return null;
            }
        };
    }
}

