/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.impl;

import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang.StringUtils;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.impl.AbstractRrdBasedFetchStrategy;
import org.opennms.netmgt.measurements.impl.Utils;
import org.opennms.netmgt.measurements.model.QueryMetadata;
import org.opennms.netmgt.measurements.model.Source;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.model.RrdXport;
import org.opennms.netmgt.rrd.model.XRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class RrdtoolXportFetchStrategy
extends AbstractRrdBasedFetchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RrdtoolXportFetchStrategy.class);
    public static final long XPORT_TIMEOUT_MS = 120000L;

    @Override
    protected FetchResults fetchMeasurements(long start, long end, long step, int maxrows, Map<Source, String> rrdsBySource, Map<String, Object> constants, QueryMetadata metadata) throws RrdException {
        RrdXport rrdXport;
        String rrdBinary = System.getProperty("rrd.binary");
        if (rrdBinary == null) {
            throw new RrdException("No RRD binary is set.");
        }
        long startInSeconds = (long)Math.floor((double)start / 1000.0);
        long endInSeconds = (long)Math.floor((double)end / 1000.0);
        long stepInSeconds = (long)Math.floor((double)step / 1000.0);
        if (stepInSeconds <= 0L) {
            stepInSeconds = 1L;
        }
        CommandLine cmdLine = new CommandLine(rrdBinary);
        cmdLine.addArgument("xport");
        cmdLine.addArgument("--step");
        cmdLine.addArgument("" + stepInSeconds);
        cmdLine.addArgument("--start");
        cmdLine.addArgument("" + startInSeconds);
        cmdLine.addArgument("--end");
        cmdLine.addArgument("" + endInSeconds);
        if (maxrows > 0) {
            cmdLine.addArgument("--maxrows");
            cmdLine.addArgument("" + maxrows);
        }
        HashMap labelMap = Maps.newHashMap();
        int k = 0;
        for (Map.Entry<Source, String> entry : rrdsBySource.entrySet()) {
            Source source = entry.getKey();
            String rrdFile = entry.getValue();
            String tempLabel = Integer.toString(++k);
            labelMap.put(tempLabel, source.getLabel());
            if (source.getEffectiveDataSource().length() > 19) {
                source.setDataSource(source.getEffectiveDataSource().substring(0, 19));
            }
            cmdLine.addArgument(String.format("DEF:%s=%s:%s:%s", tempLabel, Utils.escapeColons(rrdFile), Utils.escapeColons(source.getEffectiveDataSource()), source.getAggregation()));
            cmdLine.addArgument(String.format("XPORT:%s:%s", tempLabel, tempLabel));
        }
        DefaultExecutor executor = new DefaultExecutor();
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)stdout, (OutputStream)stderr, null));
        executor.setExitValue(0);
        ExecuteWatchdog watchdog = new ExecuteWatchdog(120000L);
        executor.setWatchdog(watchdog);
        try {
            LOG.debug("Executing: {}", (Object)cmdLine);
            executor.execute(cmdLine);
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SAXSource source = new SAXSource(xmlReader, new InputSource(new StringReader(stdout.toString())));
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{RrdXport.class});
            Unmarshaller u = jc.createUnmarshaller();
            rrdXport = (RrdXport)u.unmarshal((javax.xml.transform.Source)source);
        }
        catch (IOException e) {
            throw new RrdException("An error occured while executing '" + StringUtils.join((Object[])cmdLine.toStrings(), (String)" ") + "' with stderr: " + stderr.toString(), (Throwable)e);
        }
        catch (JAXBException | SAXException e) {
            throw new RrdException("The output generated by 'rrdtool xport' could not be parsed.", e);
        }
        int numRows = rrdXport.getRows().size();
        int numColumns = rrdXport.getMeta().getLegends().size();
        long xportStartInMs = rrdXport.getMeta().getStart() * 1000L;
        long xportStepInMs = rrdXport.getMeta().getStep() * 1000L;
        long[] timestamps = new long[numRows];
        double[][] values = new double[numColumns][numRows];
        int i = 0;
        for (XRow row : rrdXport.getRows()) {
            timestamps[i] = xportStartInMs + xportStepInMs * (long)i;
            for (int j = 0; j < numColumns; ++j) {
                if (row.getValues() == null) {
                    throw new RrdException("The output generated by 'rrdtool xport' was not recognized. Try upgrading your rrdtool binaries.");
                }
                values[j][i] = (Double)row.getValues().get(j);
            }
            ++i;
        }
        HashMap columns = Maps.newHashMapWithExpectedSize((int)numColumns);
        i = 0;
        for (String label : rrdXport.getMeta().getLegends()) {
            columns.put((String)labelMap.get(label), values[i++]);
        }
        return new FetchResults(timestamps, (Map)columns, xportStepInMs, constants, metadata);
    }
}

