/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.docpath;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.ws.commons.schema.docpath.XmlSchemaPathNode;
import org.apache.ws.commons.schema.docpath.XmlSchemaStateMachineNode;

public final class XmlSchemaDocumentNode<U> {
    private XmlSchemaStateMachineNode stateMachineNode;
    private XmlSchemaDocumentNode<U> parent;
    private List<SortedMap<Integer, XmlSchemaDocumentNode<U>>> children;
    private List<XmlSchemaPathNode<U, ?>> visitors;
    private boolean receivedContent;
    private U userDefinedContent = null;

    XmlSchemaDocumentNode(XmlSchemaDocumentNode<U> parent, XmlSchemaStateMachineNode stateMachineNode) {
        this.set(parent, stateMachineNode);
    }

    public XmlSchemaStateMachineNode getStateMachineNode() {
        return this.stateMachineNode;
    }

    public XmlSchemaDocumentNode<U> getParent() {
        return this.parent;
    }

    public SortedMap<Integer, XmlSchemaDocumentNode<U>> getChildren() {
        if (this.children == null) {
            return null;
        }
        return this.getChildren(this.children.size());
    }

    public SortedMap<Integer, XmlSchemaDocumentNode<U>> getChildren(int iteration) {
        if (this.children == null || this.children.size() < iteration || iteration < 1) {
            return null;
        }
        return this.children.get(iteration - 1);
    }

    boolean getReceivedContent() {
        return this.receivedContent;
    }

    void setReceivedContent(boolean receivedContent) {
        this.receivedContent = receivedContent;
    }

    void addVisitor(XmlSchemaPathNode<U, ?> path) {
        if (path.getDocumentNode() != this) {
            throw new IllegalArgumentException("Path node must have this XmlSchemaDocumentNode as its document node.");
        }
        switch (path.getDirection()) {
            case CHILD: 
            case SIBLING: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Only CHILD and SIBLING paths may be visitors of an XmlSchemaDocumentNode, not a " + (Object)((Object)path.getDirection()) + " path.");
            }
        }
        if (this.visitors == null) {
            this.visitors = new ArrayList(4);
        }
        if (this.children != null) {
            if (this.children.size() == this.visitors.size()) {
                this.children.add(new TreeMap());
            } else {
                throw new IllegalStateException("Attempted to add a new visitor when the number of occurrences (" + this.children.size() + ") did not match the number of existing visitors (" + this.visitors.size() + ").");
            }
        }
        this.visitors.add(path);
    }

    boolean removeVisitor(XmlSchemaPathNode<U, ?> path) {
        int visitorIndex;
        if (this.visitors == null || this.visitors.isEmpty()) {
            return false;
        }
        if (this.children != null && this.visitors.size() != this.children.size()) {
            throw new IllegalStateException("The number of visitors (" + this.visitors.size() + ") does not match the number of occurrences (" + this.children.size() + ").");
        }
        for (visitorIndex = 0; visitorIndex < this.visitors.size() && this.visitors.get(visitorIndex) != path; ++visitorIndex) {
        }
        if (this.visitors.size() == visitorIndex) {
            return false;
        }
        this.visitors.remove(visitorIndex);
        if (this.children != null) {
            this.children.remove(visitorIndex);
        }
        return true;
    }

    public int getIteration() {
        if (this.children != null && this.children.size() != this.visitors.size()) {
            throw new IllegalStateException("The number of occurrences (" + this.children.size() + ") is not equal to the number of visitors (" + this.visitors.size() + ").");
        }
        return this.visitors.size();
    }

    public long getMinOccurs() {
        return this.stateMachineNode.getMinOccurs();
    }

    public long getMaxOccurs() {
        return this.stateMachineNode.getMaxOccurs();
    }

    int getSequencePosition() {
        if (this.children == null || !this.stateMachineNode.getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.SEQUENCE)) {
            return -1;
        }
        if (this.children.isEmpty()) {
            return 0;
        }
        if (this.children.get(this.children.size() - 1).isEmpty()) {
            return 0;
        }
        return this.children.get(this.children.size() - 1).lastKey();
    }

    void set(XmlSchemaDocumentNode<U> parent, XmlSchemaStateMachineNode stateMachineNode) {
        this.parent = parent;
        this.stateMachineNode = stateMachineNode;
        this.receivedContent = false;
        this.visitors = null;
        this.children = this.stateMachineNode.getPossibleNextStates() == null || this.stateMachineNode.getPossibleNextStates().isEmpty() ? null : new ArrayList<SortedMap<Integer, XmlSchemaDocumentNode<U>>>(1);
    }

    public U getUserDefinedContent() {
        return this.userDefinedContent;
    }

    public void setUserDefinedContent(U userDefinedContent) {
        this.userDefinedContent = userDefinedContent;
    }
}

