/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.endpoints.grafana.service;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.endpoints.grafana.api.GrafanaClient;
import org.opennms.netmgt.endpoints.grafana.api.GrafanaClientFactory;
import org.opennms.netmgt.endpoints.grafana.api.GrafanaEndpoint;
import org.opennms.netmgt.endpoints.grafana.api.GrafanaEndpointException;
import org.opennms.netmgt.endpoints.grafana.api.GrafanaEndpointService;
import org.opennms.netmgt.endpoints.grafana.persistence.api.GrafanaEndpointDao;

public class GrafanaEndpointServiceImpl
implements GrafanaEndpointService {
    static final Pattern UID_PATTERN = Pattern.compile("^[a-zA-Z0-9]+[a-zA-Z0-9_-]*$");
    static final String PROVIDE_A_VALUE_TEXT = "Please provide a value";
    static final String URL_NOT_VALID_TEMPLATE = "The provided URL ''{0}'' is not valid: ''{1}''";
    static final String PROVIDED_VALUE_GREATER_ZERO_TEXT = "The provided value must be >= 0";
    static final String UID_INVALID_TEMPLATE = "The provided Grafana ID ''{0}'' is not valid. It does not match the regular expression ''{1}''";
    private final GrafanaEndpointDao endpointDao;
    private final GrafanaClientFactory clientFactory;
    private final SessionUtils sessionUtils;

    public GrafanaEndpointServiceImpl(GrafanaEndpointDao endpointDao, GrafanaClientFactory clientFactory, SessionUtils sessionUtils) {
        this.endpointDao = Objects.requireNonNull(endpointDao);
        this.clientFactory = Objects.requireNonNull(clientFactory);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
    }

    public List<GrafanaEndpoint> findEndpoints() {
        List endpoints = (List)this.sessionUtils.withReadOnlyTransaction(() -> this.endpointDao.findAll());
        Collections.sort(endpoints, Comparator.comparing(GrafanaEndpoint::getId));
        return endpoints;
    }

    public void deleteAllEndpoints() {
        this.sessionUtils.withTransaction(() -> {
            this.endpointDao.findAll().forEach(endpoint -> this.endpointDao.delete(endpoint));
            return null;
        });
    }

    public void updateEndpoint(GrafanaEndpoint endpoint) throws NoSuchElementException {
        this.sessionUtils.withTransaction(() -> {
            this.validate(endpoint);
            GrafanaEndpoint persistedEndpoint = this.findEndpoint(endpoint.getId());
            persistedEndpoint.merge(endpoint);
            this.endpointDao.update((Object)persistedEndpoint);
            return null;
        });
    }

    public void saveEndpoint(GrafanaEndpoint newGrafanaEndpoint) throws NoSuchElementException {
        this.sessionUtils.withTransaction(() -> {
            this.validate(newGrafanaEndpoint);
            this.endpointDao.save((Object)newGrafanaEndpoint);
            return null;
        });
    }

    public void deleteEndpoint(GrafanaEndpoint grafanaEndpoint) throws NoSuchElementException {
        this.sessionUtils.withTransaction(() -> {
            GrafanaEndpoint endpoint = this.findEndpoint(grafanaEndpoint.getId());
            this.endpointDao.delete((Object)endpoint);
            return true;
        });
    }

    public GrafanaEndpoint getEndpointById(Long endpointId) {
        return (GrafanaEndpoint)this.sessionUtils.withReadOnlyTransaction(() -> this.findEndpoint(endpointId));
    }

    public GrafanaEndpoint getEndpointByUid(String uid) {
        return (GrafanaEndpoint)this.sessionUtils.withReadOnlyTransaction(() -> this.findEndpoint(uid));
    }

    public GrafanaClient getClient(GrafanaEndpoint grafanaEndpoint) {
        return this.clientFactory.createClient(grafanaEndpoint);
    }

    public GrafanaClient getClient(String uid) throws NoSuchElementException {
        return this.clientFactory.createClient(this.findEndpoint(uid));
    }

    private GrafanaEndpoint findEndpoint(Long endpointId) throws NoSuchElementException {
        GrafanaEndpoint grafanaEndpoint = (GrafanaEndpoint)this.endpointDao.get((Serializable)endpointId);
        if (grafanaEndpoint == null) {
            new NoSuchElementException("Could not find grafana endpoint with id '" + endpointId + "'");
        }
        return grafanaEndpoint;
    }

    private GrafanaEndpoint findEndpoint(String uid) throws NoSuchElementException {
        GrafanaEndpoint grafanaEndpoint = this.endpointDao.getByUid(uid);
        if (grafanaEndpoint == null) {
            new NoSuchElementException("Could not find grafana endpoint with uid '" + uid + "'");
        }
        return grafanaEndpoint;
    }

    void validate(GrafanaEndpoint endpoint) {
        if (Strings.isNullOrEmpty((String)endpoint.getUrl())) {
            throw new GrafanaEndpointException("url", PROVIDE_A_VALUE_TEXT);
        }
        try {
            new URL(endpoint.getUrl());
        }
        catch (MalformedURLException e) {
            throw new GrafanaEndpointException("url", URL_NOT_VALID_TEMPLATE, new Object[]{endpoint.getUrl(), e.getMessage()});
        }
        if (Strings.isNullOrEmpty((String)endpoint.getApiKey())) {
            throw new GrafanaEndpointException("apiKey", PROVIDE_A_VALUE_TEXT);
        }
        if (Strings.isNullOrEmpty((String)endpoint.getUid())) {
            throw new GrafanaEndpointException("uid", PROVIDE_A_VALUE_TEXT);
        }
        if (endpoint.getConnectTimeout() != null && endpoint.getConnectTimeout() < 0) {
            throw new GrafanaEndpointException("connectTimeout", PROVIDED_VALUE_GREATER_ZERO_TEXT);
        }
        if (endpoint.getReadTimeout() != null && endpoint.getReadTimeout() < 0) {
            throw new GrafanaEndpointException("readTimeout", PROVIDED_VALUE_GREATER_ZERO_TEXT);
        }
        if (!UID_PATTERN.matcher(endpoint.getUid()).matches()) {
            throw new GrafanaEndpointException("uid", UID_INVALID_TEMPLATE, new Object[]{endpoint.getUid(), UID_PATTERN.pattern()});
        }
        GrafanaEndpoint byUid = this.endpointDao.getByUid(endpoint.getUid());
        if (byUid != null && !byUid.getId().equals(endpoint.getId())) {
            throw new GrafanaEndpointException("uid", "An endpoint with uid ''{0}'' already exists.", new Object[]{endpoint.getUid()});
        }
    }
}

