/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.internal.collection;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.config.api.collection.IGroup;
import org.opennms.netmgt.config.api.collection.IMibObject;
import org.opennms.netmgt.config.internal.collection.GroupImpl;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpObjIdXmlAdapter;

@XmlRootElement(name="mibObj")
@XmlAccessorType(value=XmlAccessType.NONE)
public class MibObjectImpl
implements IMibObject {
    @XmlAttribute(name="oid")
    @XmlJavaTypeAdapter(value=SnmpObjIdXmlAdapter.class)
    private SnmpObjId m_oid;
    @XmlAttribute(name="instance")
    private String m_instance;
    @XmlAttribute(name="alias")
    private String m_alias;
    @XmlAttribute(name="type")
    private String m_type;
    @XmlTransient
    private GroupImpl m_group;

    public MibObjectImpl() {
    }

    public MibObjectImpl(String oid, String instance, String alias, String type) {
        this.m_oid = SnmpObjId.get((String)oid);
        this.m_instance = instance;
        this.m_alias = alias;
        this.m_type = type;
    }

    @Override
    public SnmpObjId getOid() {
        return this.m_oid;
    }

    public void setOid(SnmpObjId oid) {
        this.m_oid = oid;
    }

    public void setOid(String oid) {
        this.m_oid = SnmpObjId.get((String)oid);
    }

    @Override
    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    @Override
    public String getInstance() {
        return this.m_instance;
    }

    public void setInstance(String instance) {
        this.m_instance = instance;
    }

    @Override
    public IGroup getGroup() {
        return this.m_group;
    }

    public void setGroup(IGroup group) {
        this.m_group = GroupImpl.asGroup(group);
    }

    public static MibObjectImpl[] asMibObjects(IMibObject[] mibObjects) {
        if (mibObjects == null) {
            return null;
        }
        MibObjectImpl[] newMibObjects = new MibObjectImpl[mibObjects.length];
        for (int i = 0; i < mibObjects.length; ++i) {
            newMibObjects[i] = MibObjectImpl.asMibObject(mibObjects[i]);
        }
        return newMibObjects;
    }

    private static MibObjectImpl asMibObject(IMibObject obj) {
        if (obj == null) {
            return null;
        }
        MibObjectImpl mibObject = new MibObjectImpl();
        mibObject.setOid(obj.getOid());
        mibObject.setAlias(obj.getAlias());
        mibObject.setType(obj.getType());
        mibObject.setInstance(obj.getInstance());
        mibObject.setGroup(obj.getGroup());
        return mibObject;
    }

    public String toString() {
        return "MibObjectImpl [oid=" + String.valueOf(this.m_oid) + ", alias=" + this.m_alias + ", type=" + this.m_type + ", instance=" + this.m_instance + ", group=" + String.valueOf(this.m_group) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_alias == null ? 0 : this.m_alias.hashCode());
        result = 31 * result + (this.m_group == null ? 0 : this.m_group.hashCode());
        result = 31 * result + (this.m_instance == null ? 0 : this.m_instance.hashCode());
        result = 31 * result + (this.m_oid == null ? 0 : this.m_oid.hashCode());
        result = 31 * result + (this.m_type == null ? 0 : this.m_type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MibObjectImpl)) {
            return false;
        }
        MibObjectImpl other = (MibObjectImpl)obj;
        if (this.m_alias == null ? other.m_alias != null : !this.m_alias.equals(other.m_alias)) {
            return false;
        }
        if (this.m_group == null ? other.m_group != null : !this.m_group.equals(other.m_group)) {
            return false;
        }
        if (this.m_instance == null ? other.m_instance != null : !this.m_instance.equals(other.m_instance)) {
            return false;
        }
        if (this.m_oid == null ? other.m_oid != null : !this.m_oid.equals((Object)other.m_oid)) {
            return false;
        }
        return !(this.m_type == null ? other.m_type != null : !this.m_type.equals(other.m_type));
    }
}

