/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import java.util.ArrayList;
import java.util.Collection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.search.ReportedData;
import org.jivesoftware.smackx.search.UserSearch;
import org.jivesoftware.smackx.xdata.Form;

public class UserSearchManager {
    private XMPPConnection con;
    private UserSearch userSearch;

    public UserSearchManager(XMPPConnection con) {
        this.con = con;
        this.userSearch = new UserSearch();
    }

    public Form getSearchForm(String searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.userSearch.getSearchForm(this.con, searchService);
    }

    public ReportedData getSearchResults(Form searchForm, String searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.userSearch.sendSearchForm(this.con, searchForm, searchService);
    }

    public Collection<String> getSearchServices() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<String> searchServices = new ArrayList<String>();
        ServiceDiscoveryManager discoManager = ServiceDiscoveryManager.getInstanceFor(this.con);
        DiscoverItems items = discoManager.discoverItems(this.con.getServiceName());
        for (DiscoverItems.Item item : items.getItems()) {
            try {
                DiscoverInfo info;
                try {
                    info = discoManager.discoverInfo(item.getEntityID());
                }
                catch (XMPPException e) {
                    continue;
                }
                if (!info.containsFeature("jabber:iq:search")) continue;
                searchServices.add(item.getEntityID());
            }
            catch (Exception e) {
                break;
            }
        }
        return searchServices;
    }
}

