/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMDateTime;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.Numeric;
import org.sblim.wbem.cim.UnsignedInt16;
import org.sblim.wbem.cim.UnsignedInt32;
import org.sblim.wbem.cim.UnsignedInt64;
import org.sblim.wbem.cim.UnsignedInt8;

public class CIMDataType
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8636134893815214662L;
    private static final int SINGLE_BASE = 0;
    private static final int ARRAY_BASE = 16;
    private static final int SPECIAL_BASE = 31;
    public static final int INVALID = -1;
    public static final int UINT8 = 0;
    public static final int SINT8 = 1;
    public static final int UINT16 = 2;
    public static final int SINT16 = 3;
    public static final int UINT32 = 4;
    public static final int SINT32 = 5;
    public static final int UINT64 = 6;
    public static final int SINT64 = 7;
    public static final int STRING = 8;
    public static final int BOOLEAN = 9;
    public static final int REAL32 = 10;
    public static final int REAL64 = 11;
    public static final int DATETIME = 12;
    public static final int CHAR16 = 13;
    public static final int REFERENCE = 14;
    public static final int NUMERIC = 15;
    public static final int UINT8_ARRAY = 16;
    public static final int SINT8_ARRAY = 17;
    public static final int UINT16_ARRAY = 18;
    public static final int SINT16_ARRAY = 19;
    public static final int UINT32_ARRAY = 20;
    public static final int SINT32_ARRAY = 21;
    public static final int UINT64_ARRAY = 22;
    public static final int SINT64_ARRAY = 23;
    public static final int STRING_ARRAY = 24;
    public static final int BOOLEAN_ARRAY = 25;
    public static final int REAL32_ARRAY = 26;
    public static final int REAL64_ARRAY = 27;
    public static final int DATETIME_ARRAY = 28;
    public static final int CHAR16_ARRAY = 29;
    public static final int REFERENCE_ARRAY = 30;
    public static final int OBJECT = 31;
    public static final int NULL = 32;
    public static final int CLASS = 33;
    public static final int SIZE_SINGLE = -1;
    public static final int SIZE_UNLIMITED = -2;
    public static final int MIN_SINGLE_TYPE = 0;
    public static final int MAX_SINGLE_TYPE = 15;
    public static final int MIN_ARRAY_TYPE = 16;
    public static final int MAX_ARRAY_TYPE = 30;
    private static final int MAX_DATA_TYPE = 33;
    private static CIMDataType[] predefinedDataType = new CIMDataType[34];
    public static final CIMDataType INVALID_DATATYPE;
    public static final CIMDataType NULL_DATATYPE;
    private static final String EMPTY = "";
    private int type = -1;
    private int size = -1;
    private String referenceClass = "";

    public CIMDataType(int pType) {
        this.setType(pType);
    }

    public CIMDataType(int pType, int pSize) {
        if (pType < 16 || pType > 30) {
            if (pType >= 0 && pType <= 15) {
                pType += 16;
            } else {
                throw new IllegalArgumentException("Invalid data type:" + pType);
            }
        }
        if (pSize < -2 || pSize == -1) {
            throw new IllegalArgumentException("Invalid size of the data type:" + pSize);
        }
        this.type = pType;
        this.size = pSize;
    }

    private CIMDataType() {
    }

    public CIMDataType(String pRefClassName) {
        this.type = 14;
        this.size = -1;
        this.referenceClass = pRefClassName == null ? EMPTY : pRefClassName;
    }

    public CIMDataType(String pRefClassName, int pSize) {
        if (pSize < -2) {
            throw new IllegalArgumentException("invalid size argument: " + pSize);
        }
        this.size = pSize;
        this.type = this.size >= 0 || this.size == -2 ? 30 : 14;
        this.referenceClass = pRefClassName == null ? EMPTY : pRefClassName;
    }

    public String getRefClassName() {
        return this.referenceClass;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof CIMDataType) {
            CIMDataType that = (CIMDataType)obj;
            if (this.type == that.type && this.size == that.size && (this.referenceClass == null ? that.referenceClass == null : this.referenceClass.equalsIgnoreCase(that.referenceClass))) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.referenceClass.toUpperCase().hashCode() << 16 + this.size << 8 + this.type;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int pType) {
        if (pType == 14 || pType == 30 || pType == 32) {
            // empty if block
        }
        if (pType >= 16 && pType <= 30) {
            this.size = -2;
        } else if (pType >= 0 && pType <= 15) {
            this.size = -1;
        } else if (pType != -1 && pType != 32 && pType != 33 && pType != 31) {
            throw new IllegalArgumentException("Invalid data type");
        }
        this.type = pType;
    }

    public int getSize() {
        return this.size;
    }

    public static int findType(Object pValue) {
        if (pValue == null) {
            return 32;
        }
        if (pValue instanceof Vector) {
            return CIMDataType.findType((Vector)pValue);
        }
        if (pValue instanceof UnsignedInt8) {
            return 0;
        }
        if (pValue instanceof UnsignedInt16) {
            return 2;
        }
        if (pValue instanceof UnsignedInt32) {
            return 4;
        }
        if (pValue instanceof UnsignedInt64) {
            return 6;
        }
        if (pValue instanceof Byte) {
            return 1;
        }
        if (pValue instanceof Short) {
            return 3;
        }
        if (pValue instanceof Integer) {
            return 5;
        }
        if (pValue instanceof Long) {
            return 7;
        }
        if (pValue instanceof String) {
            return 8;
        }
        if (pValue instanceof Boolean) {
            return 9;
        }
        if (pValue instanceof Float) {
            return 10;
        }
        if (pValue instanceof Double) {
            return 11;
        }
        if (pValue instanceof CIMDateTime) {
            return 12;
        }
        if (pValue instanceof CIMObjectPath) {
            return 14;
        }
        if (pValue instanceof CIMInstance) {
            return 31;
        }
        if (pValue instanceof CIMClass) {
            return 33;
        }
        if (pValue instanceof Character) {
            return 13;
        }
        if (pValue instanceof Numeric) {
            return 15;
        }
        return -1;
    }

    private static int findType(Vector pVector) {
        if (pVector == null) {
            return 32;
        }
        Iterator iter = pVector.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj == null) continue;
            return CIMDataType.findArrayType(CIMDataType.findType(obj));
        }
        return 32;
    }

    public static CIMDataType getDataType(String typeStr, boolean isArray) {
        return isArray ? TypeFactory.getArray(typeStr) : TypeFactory.getScalar(typeStr);
    }

    public static CIMDataType getPredefinedType(int pType) {
        try {
            if (pType == -1) {
                return INVALID_DATATYPE;
            }
            return (CIMDataType)predefinedDataType[pType].clone();
        }
        catch (Exception e) {
            return INVALID_DATATYPE;
        }
    }

    public boolean isArrayType() {
        return this.type >= 16 && this.type <= 30;
    }

    public static boolean isTypeCompatible(Object pValue, CIMDataType pDataType) {
        boolean isCompatible = false;
        int valueType = CIMDataType.findType(pValue);
        int valueDataType = pDataType.isArrayType() ? pDataType.getType() - 16 : pDataType.getType();
        switch (valueDataType) {
            case 0: {
                if (valueType == 0 && valueType == 15) break;
                isCompatible = true;
                break;
            }
            case 2: {
                if (valueType != 0 && valueType == 2 && valueType == 15) break;
                isCompatible = true;
                break;
            }
            case 4: {
                if (valueType != 0 && valueType != 2 && valueType != 4 && valueType == 15) break;
                isCompatible = true;
                break;
            }
            case 6: {
                if (valueType != 0 && valueType != 2 && valueType != 4 && valueType != 6 && valueType == 15) break;
                isCompatible = true;
                break;
            }
            case 1: {
                if (valueType != 1 && valueType == 15) break;
                isCompatible = true;
                break;
            }
            case 3: {
                if (valueType != 1 && valueType != 3 && valueType != 0 && valueType == 15) break;
                isCompatible = true;
                break;
            }
            case 5: {
                if (valueType != 1 && valueType != 3 && valueType != 5 && valueType != 0 && valueType != 2 && valueType == 15) break;
                isCompatible = true;
                break;
            }
            case 7: {
                if (valueType != 1 && valueType != 3 && valueType != 5 && valueType != 7 && valueType != 0 && valueType != 2 && valueType != 4 && valueType == 15) break;
                isCompatible = true;
                break;
            }
            case 8: {
                if (valueType != 8) break;
                isCompatible = true;
                break;
            }
            case 9: {
                if (valueType != 9) break;
                isCompatible = true;
                break;
            }
            case 10: {
                if (valueType != 10 && valueType == 15) break;
                isCompatible = true;
                break;
            }
            case 11: {
                if (valueType != 10 && valueType == 11 && valueType == 15) break;
                isCompatible = true;
                break;
            }
            case 12: {
                if (valueType != 12 && valueType != 8) break;
                isCompatible = true;
                break;
            }
            case 13: {
                if (valueType != 13 && valueType != 8) break;
                isCompatible = true;
                break;
            }
            case 14: {
                if (valueType != 14) break;
                isCompatible = true;
                break;
            }
            case 31: {
                if (valueType != 31) break;
                isCompatible = true;
                break;
            }
            case 15: {
                if (valueType != 15 && valueType != 0 && valueType != 2 && valueType != 4 && valueType != 6 && valueType != 1 && valueType != 3 && valueType != 5 && valueType != 7 && valueType != 10 && valueType != 11) break;
                isCompatible = true;
            }
        }
        return isCompatible;
    }

    public boolean isReferenceType() {
        return this.type == 30 || this.type == 14;
    }

    public Object clone() {
        CIMDataType dt = new CIMDataType();
        dt.size = this.size;
        dt.type = this.type;
        dt.referenceClass = this.referenceClass;
        return dt;
    }

    public static int findArrayType(int pSimpleType) {
        if (pSimpleType >= 0 && pSimpleType <= 14) {
            return pSimpleType + 16;
        }
        if (pSimpleType == 32) {
            return 32;
        }
        return -1;
    }

    public static int findSimpleType(int pArrayType) {
        if (pArrayType >= 16 && pArrayType <= 30) {
            return pArrayType - 16;
        }
        if (pArrayType == 32) {
            return 32;
        }
        return -1;
    }

    public String getStringType() {
        String result;
        switch (this.type) {
            case 0: 
            case 16: {
                result = "uint8";
                break;
            }
            case 2: 
            case 18: {
                result = "uint16";
                break;
            }
            case 4: 
            case 20: {
                result = "uint32";
                break;
            }
            case 6: 
            case 22: {
                result = "uint64";
                break;
            }
            case 1: 
            case 17: {
                result = "sint8";
                break;
            }
            case 3: 
            case 19: {
                result = "sint16";
                break;
            }
            case 5: 
            case 21: {
                result = "sint32";
                break;
            }
            case 7: 
            case 23: {
                result = "sint64";
                break;
            }
            case 8: 
            case 24: {
                result = "string";
                break;
            }
            case 9: 
            case 25: {
                result = "boolean";
                break;
            }
            case 10: 
            case 26: {
                result = "real32";
                break;
            }
            case 11: 
            case 27: {
                result = "real64";
                break;
            }
            case 12: 
            case 28: {
                result = "datetime";
                break;
            }
            case 13: 
            case 29: {
                result = "char16";
                break;
            }
            case 15: {
                result = "numeric";
                break;
            }
            case 32: {
                result = "null";
                break;
            }
            case 14: {
                result = this.getRefClassName() + " ref";
                break;
            }
            case 30: {
                result = this.getRefClassName() + "[" + (this.size > -1 ? String.valueOf(this.size) : EMPTY) + "] ref";
                break;
            }
            default: {
                result = EMPTY;
            }
        }
        return result;
    }

    public String toMOF() {
        String result = this.getStringType();
        if (this.isArrayType() && this.type != 30) {
            result = this.size > -1 ? result + "[" + this.size + "]" : result + "[]";
        }
        return result;
    }

    public String toString() {
        return this.toMOF();
    }

    public static void main(String[] args) {
        CIMDataType type = new CIMDataType("CIM_ComputerSystem", 10);
        System.out.println(type);
        type = new CIMDataType("CIM_ComputerSystem", -1);
        System.out.println(type);
        type = new CIMDataType("CIM_ComputerSystem", -2);
        System.out.println(type);
        type = new CIMDataType("CIM_ComputerSystem", -10);
        System.out.println(type);
    }

    static {
        CIMDataType.predefinedDataType[0] = new CIMDataType(0);
        CIMDataType.predefinedDataType[2] = new CIMDataType(2);
        CIMDataType.predefinedDataType[4] = new CIMDataType(4);
        CIMDataType.predefinedDataType[6] = new CIMDataType(6);
        CIMDataType.predefinedDataType[1] = new CIMDataType(1);
        CIMDataType.predefinedDataType[3] = new CIMDataType(3);
        CIMDataType.predefinedDataType[5] = new CIMDataType(5);
        CIMDataType.predefinedDataType[7] = new CIMDataType(7);
        CIMDataType.predefinedDataType[8] = new CIMDataType(8);
        CIMDataType.predefinedDataType[13] = new CIMDataType(13);
        CIMDataType.predefinedDataType[9] = new CIMDataType(9);
        CIMDataType.predefinedDataType[10] = new CIMDataType(10);
        CIMDataType.predefinedDataType[11] = new CIMDataType(11);
        CIMDataType.predefinedDataType[12] = new CIMDataType(12);
        CIMDataType.predefinedDataType[14] = new CIMDataType(14);
        CIMDataType.predefinedDataType[15] = new CIMDataType(15);
        CIMDataType.predefinedDataType[16] = new CIMDataType(16);
        CIMDataType.predefinedDataType[18] = new CIMDataType(18);
        CIMDataType.predefinedDataType[20] = new CIMDataType(20);
        CIMDataType.predefinedDataType[22] = new CIMDataType(22);
        CIMDataType.predefinedDataType[17] = new CIMDataType(17);
        CIMDataType.predefinedDataType[19] = new CIMDataType(19);
        CIMDataType.predefinedDataType[21] = new CIMDataType(21);
        CIMDataType.predefinedDataType[23] = new CIMDataType(23);
        CIMDataType.predefinedDataType[24] = new CIMDataType(24);
        CIMDataType.predefinedDataType[29] = new CIMDataType(29);
        CIMDataType.predefinedDataType[25] = new CIMDataType(25);
        CIMDataType.predefinedDataType[26] = new CIMDataType(26);
        CIMDataType.predefinedDataType[27] = new CIMDataType(27);
        CIMDataType.predefinedDataType[28] = new CIMDataType(28);
        CIMDataType.predefinedDataType[30] = new CIMDataType(30);
        CIMDataType.predefinedDataType[31] = new CIMDataType(31);
        CIMDataType.predefinedDataType[32] = new CIMDataType(32);
        CIMDataType.predefinedDataType[33] = new CIMDataType(33);
        INVALID_DATATYPE = new CIMDataType(-1);
        NULL_DATATYPE = new CIMDataType(32);
    }

    private static class TypeFactory {
        private static HashMap cScalarTypeMap;
        private static HashMap cArrayTypeMap;

        private TypeFactory() {
        }

        private static void add(String pTypeStr, int pTypeCode) {
            cScalarTypeMap.put(pTypeStr, CIMDataType.getPredefinedType(pTypeCode));
            if (pTypeCode >= 0 && pTypeCode <= 15) {
                cArrayTypeMap.put(pTypeStr, CIMDataType.getPredefinedType(pTypeCode + 16));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void initMaps() {
            if (cScalarTypeMap != null) {
                return;
            }
            cScalarTypeMap = new HashMap();
            cArrayTypeMap = new HashMap();
            HashMap hashMap = cScalarTypeMap;
            synchronized (hashMap) {
                HashMap hashMap2 = cArrayTypeMap;
                synchronized (hashMap2) {
                    TypeFactory.add("uint8", 0);
                    TypeFactory.add("uint16", 2);
                    TypeFactory.add("uint32", 4);
                    TypeFactory.add("uint64", 6);
                    TypeFactory.add("sint8", 1);
                    TypeFactory.add("sint16", 3);
                    TypeFactory.add("sint32", 5);
                    TypeFactory.add("sint64", 7);
                    TypeFactory.add("string", 8);
                    TypeFactory.add("boolean", 9);
                    TypeFactory.add("real32", 10);
                    TypeFactory.add("real64", 11);
                    TypeFactory.add("datetime", 12);
                    TypeFactory.add("ref", 14);
                    TypeFactory.add("reference", 14);
                    TypeFactory.add("char16", 13);
                    TypeFactory.add("numeric", 15);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CIMDataType getScalar(String pTypeStr) {
            CIMDataType type;
            TypeFactory.initMaps();
            pTypeStr = pTypeStr.toLowerCase();
            HashMap hashMap = cScalarTypeMap;
            synchronized (hashMap) {
                type = (CIMDataType)cScalarTypeMap.get(pTypeStr);
            }
            if (type == null) {
                return CIMDataType.getPredefinedType(8);
            }
            return (CIMDataType)type.clone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CIMDataType getArray(String pTypeStr) {
            CIMDataType type;
            TypeFactory.initMaps();
            pTypeStr = pTypeStr.toLowerCase();
            HashMap hashMap = cArrayTypeMap;
            synchronized (hashMap) {
                type = (CIMDataType)cArrayTypeMap.get(pTypeStr);
            }
            if (type == null) {
                return CIMDataType.getPredefinedType(24);
            }
            return (CIMDataType)type.clone();
        }
    }
}

