/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm.info;

import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.info.EdgeInfoPanelItemProvider;
import org.opennms.features.topology.api.info.item.DefaultInfoPanelItem;
import org.opennms.features.topology.api.info.item.InfoPanelItem;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceEdge;
import org.opennms.netmgt.bsm.service.model.functions.map.Decrease;
import org.opennms.netmgt.bsm.service.model.functions.map.Identity;
import org.opennms.netmgt.bsm.service.model.functions.map.Ignore;
import org.opennms.netmgt.bsm.service.model.functions.map.Increase;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunction;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunctionVisitor;
import org.opennms.netmgt.bsm.service.model.functions.map.SetTo;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class BusinessServiceEdgeInfoPanelItemProvider
extends EdgeInfoPanelItemProvider {
    protected boolean contributeTo(EdgeRef edgeRef, GraphContainer container) {
        return "bsm".equals(edgeRef.getNamespace());
    }

    protected InfoPanelItem createInfoPanelItem(EdgeRef ref, GraphContainer graphContainer) {
        return new DefaultInfoPanelItem().withComponent(this.createComponent((BusinessServiceEdge)ref)).withTitle("Map Function Details").withOrder(0);
    }

    private Component createComponent(BusinessServiceEdge ref) {
        FormLayout formLayout = new FormLayout();
        formLayout.setMargin(false);
        formLayout.setSpacing(false);
        formLayout.addComponent((Component)UIHelper.createLabel((String)"Map Function", (String)BusinessServiceEdgeInfoPanelItemProvider.describeMapFunction(ref.getMapFunction())));
        formLayout.addComponent((Component)UIHelper.createLabel((String)"Weight", (String)Float.toString(ref.getWeight())));
        return formLayout;
    }

    private static String describeMapFunction(MapFunction mapFunction) {
        return (String)mapFunction.accept((MapFunctionVisitor)new MapFunctionVisitor<String>(){

            public String visit(Decrease function) {
                return function.getClass().getSimpleName();
            }

            public String visit(Identity function) {
                return function.getClass().getSimpleName();
            }

            public String visit(Ignore function) {
                return function.getClass().getSimpleName();
            }

            public String visit(Increase function) {
                return function.getClass().getSimpleName();
            }

            public String visit(SetTo function) {
                return String.format("%s (%s)", function.getClass().getSimpleName(), function.getStatus().getLabel());
            }
        });
    }
}

