/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.application;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.MonitoredServiceStatusEntity;
import org.opennms.netmgt.graph.api.enrichment.EnrichmentGraphBuilder;
import org.opennms.netmgt.graph.api.enrichment.EnrichmentProcessor;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.api.info.Severity;
import org.opennms.netmgt.graph.api.info.StatusInfo;
import org.opennms.netmgt.graph.domain.AbstractDomainVertex;
import org.opennms.netmgt.graph.provider.application.ApplicationVertex;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsSeverity;

public class ApplicationStatusEnrichment
implements EnrichmentProcessor {
    private static final StatusInfo DEFAULT_STATUS = StatusInfo.defaultStatus().build();
    private final ApplicationDao applicationDao;

    public ApplicationStatusEnrichment(ApplicationDao applicationDao) {
        this.applicationDao = Objects.requireNonNull(applicationDao);
    }

    public boolean canEnrich(GenericGraph graph) {
        return graph.getNamespace().equals("application");
    }

    public void enrich(EnrichmentGraphBuilder graphBuilder) {
        List allVertices = graphBuilder.getView().getVertices();
        List rootVertices = graphBuilder.getView().getVertices().stream().map(ApplicationVertex::from).filter(v -> v.getApplicationId() != null).map(AbstractDomainVertex::asGenericVertex).collect(Collectors.toList());
        ArrayList childVertices = new ArrayList(allVertices);
        childVertices.removeAll(rootVertices);
        HashMap<String, StatusInfo> childStatusMap = new HashMap<String, StatusInfo>();
        HashMap<GenericVertex, StatusInfo> vertexStatusMap = new HashMap<GenericVertex, StatusInfo>();
        List applications = rootVertices.stream().map(v -> ApplicationVertex.from(v).getApplicationId()).map(id -> (OnmsApplication)this.applicationDao.get((Serializable)id)).collect(Collectors.toList());
        List result = this.applicationDao.getAlarmStatus(applications);
        for (MonitoredServiceStatusEntity eachRow : result) {
            StatusInfo statusInfo = StatusInfo.builder((OnmsSeverity)eachRow.getSeverity()).count(eachRow.getCount()).build();
            childStatusMap.put(ApplicationStatusEnrichment.toId(eachRow.getNodeId(), eachRow.getIpAddress().toString(), eachRow.getServiceTypeId()), statusInfo);
        }
        for (GenericVertex eachVertex : childVertices) {
            childStatusMap.putIfAbsent(ApplicationStatusEnrichment.toId(eachVertex), DEFAULT_STATUS);
            vertexStatusMap.put(eachVertex, (StatusInfo)childStatusMap.get(ApplicationStatusEnrichment.toId(eachVertex)));
        }
        for (GenericVertex eachRoot : rootVertices) {
            vertexStatusMap.put(eachRoot, this.buildStatusForApplication(eachRoot, graphBuilder, childStatusMap));
        }
        vertexStatusMap.entrySet().forEach(entry -> graphBuilder.property((GenericVertex)entry.getKey(), "status", (Object)((StatusInfo)entry.getValue())));
    }

    StatusInfo buildStatusForApplication(GenericVertex application, EnrichmentGraphBuilder graphBuilder, Map<String, StatusInfo> childStatusMap) {
        Collection services = graphBuilder.getView().getConnectingEdges(application);
        boolean allChildrenHaveActiveAlarms = services.size() > 0;
        StatusInfo.StatusInfoBuilder rootStatusBuilder = StatusInfo.from((StatusInfo)DEFAULT_STATUS);
        for (GenericEdge eachEdge : services) {
            GenericVertex serviceVertex = graphBuilder.getView().resolveVertex(eachEdge.getTarget());
            StatusInfo childStatus = Optional.ofNullable(childStatusMap.get(ApplicationStatusEnrichment.toId(serviceVertex))).orElse(StatusInfo.defaultStatus().build());
            Severity childSeverity = childStatus.getSeverity();
            if (Severity.Normal.isEqual(childSeverity) || Severity.Unknown.isEqual(childSeverity)) {
                allChildrenHaveActiveAlarms = false;
            }
            if (rootStatusBuilder.getSeverity().isLessThan(childSeverity)) {
                rootStatusBuilder.severity(childSeverity);
            }
            rootStatusBuilder.count(rootStatusBuilder.getCount() + childStatus.getCount());
        }
        if (allChildrenHaveActiveAlarms && rootStatusBuilder.getSeverity().isLessThan(Severity.Major)) {
            rootStatusBuilder.severity(Severity.Major);
        }
        return rootStatusBuilder.build();
    }

    static String toId(GenericVertex vertex) {
        ApplicationVertex service = new ApplicationVertex(vertex);
        return ApplicationStatusEnrichment.toId(service.getNodeRef().getNodeId(), service.getIpAddress(), service.getServiceTypeId());
    }

    static String toId(int nodeId, String ipAddress, int serviceTypeId) {
        return nodeId + "-" + ipAddress + "-" + serviceTypeId;
    }
}

